/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Time;
import javax.media.cdm.CaptureDeviceManager;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FrameRateControl;
import javax.media.format.RGBFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RingBuffer;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice,
FrameGrabbingControl {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private static final String CONTENT_TYPE = "raw";
    private CaptureSystem system;
    private String deviceId;
    private CaptureStream captureStream;
    private MyPushBufferStream pushBufferStream;
    private RingBuffer jitterBuffer;
    private int jitterbuflen = 1;
    protected Object[] controls = new Object[]{new CivilFormatControl(), new JitterBufferControl(), new VideoFrameRateControl()};
    private String deviceName = "";
    private javax.media.format.VideoFormat outputVideoFormat;
    private float frameRate = -1.0f;
    private int framesProcessed;
    private long lastTimestamp;
    private boolean connected;
    private Buffer currentBuffer;
    private Object currentBufferMutex = new Object();
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private final SynchronizedObjectHolder transferHandlerHolder = new SynchronizedObjectHolder();
    private boolean enabled = true;

    public static javax.media.format.VideoFormat convertCivilFormat(VideoFormat videoFormat) {
        int n;
        if (videoFormat.getFormatType() == 1) {
            n = 24;
        } else if (videoFormat.getFormatType() == 2) {
            n = 32;
        } else {
            throw new IllegalArgumentException();
        }
        int n2 = 3;
        int n3 = 2;
        int n4 = 1;
        float f = videoFormat.getFPS();
        float f2 = f < 0.0f ? -1.0f : f;
        return new RGBFormat(new Dimension(videoFormat.getWidth(), videoFormat.getHeight()), -1, byte[].class, f2, n, n2, n3, n4);
    }

    private static int ordinal(String string) {
        try {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void connect() throws IOException {
        logger.fine("civil: connect");
        if (this.connected) {
            return;
        }
        if (null == this.jitterBuffer) {
            this.jitterBuffer = new RingBuffer(this.jitterbuflen);
            logger.fine("jitterbuflen=" + this.jitterbuflen);
        }
        try {
            CaptureSystemFactory captureSystemFactory = DefaultCaptureSystemFactorySingleton.instance();
            this.system = captureSystemFactory.createCaptureSystem();
            this.system.init();
            logger.fine("Opening " + this.getLocator().getRemainder());
            int n = DataSource.ordinal(this.getLocator().getRemainder());
            if (n >= 0) {
                this.deviceId = this.deviceIdFromOrdinal(n);
                if (this.deviceId == null) {
                    throw new IOException("Unable to convert ordinal " + n + " to a capture device");
                }
            } else {
                this.deviceId = this.getLocator().getRemainder();
            }
            CaptureDeviceInfo captureDeviceInfo = null;
            Vector vector = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
            for (int i = 0; i < vector.size() && !(captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(i)).getLocator().getRemainder().equalsIgnoreCase(this.deviceId); ++i) {
            }
            this.deviceName = "";
            if (null != captureDeviceInfo) {
                this.deviceName = captureDeviceInfo.getName();
            }
            this.captureStream = this.system.openCaptureDeviceStream(this.deviceId);
            this.outputVideoFormat = DataSource.convertCivilFormat(this.captureStream.getVideoFormat());
            this.captureStream.setObserver((CaptureObserver)new MyCaptureObserver());
            this.pushBufferStream = new MyPushBufferStream();
        }
        catch (CaptureException captureException) {
            logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
            throw new IOException("" + (Object)((Object)captureException));
        }
        this.connected = true;
    }

    private String deviceIdFromOrdinal(int n) throws CaptureException {
        List list = this.system.getCaptureDeviceInfoList();
        if (n < 0 || n >= list.size()) {
            return null;
        }
        com.lti.civil.CaptureDeviceInfo captureDeviceInfo = (com.lti.civil.CaptureDeviceInfo)list.get(n);
        return captureDeviceInfo.getDeviceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.fine("civil: disconnect");
        if (!this.connected) {
            return;
        }
        try {
            this.stop();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
        Object object = this.currentBufferMutex;
        synchronized (object) {
            this.currentBuffer = null;
        }
        if (this.captureStream != null) {
            try {
                this.captureStream.dispose();
            }
            catch (CaptureException captureException) {
                logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
            }
            finally {
                this.captureStream = null;
            }
        }
        try {
            this.system.dispose();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
        }
        this.system = null;
        this.connected = false;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo(this.deviceName, this.getLocator(), this.getFormatControls()[0].getSupportedFormats());
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
        Object[] objectArray = this.getControls();
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            Control control = (Control)object;
            if (!clazz.isInstance(control)) continue;
            return control;
        }
        return null;
    }

    public Component getControlComponent() {
        return null;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new CivilFormatControl()};
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        if (this.pushBufferStream == null) {
            return new PushBufferStream[0];
        }
        return new PushBufferStream[]{this.pushBufferStream};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer grabFrame() {
        Buffer buffer = null;
        Object object = this.currentBufferMutex;
        synchronized (object) {
            if (null != this.currentBuffer) {
                buffer = (Buffer)this.currentBuffer.clone();
                buffer.setFormat((Format)this.currentBuffer.getFormat().clone());
            }
        }
        return buffer;
    }

    public void start() throws IOException {
        logger.fine("civil: start");
        if (this.started.getValue()) {
            logger.warning("Civil DataSource.start called while already started, ignoring");
            return;
        }
        try {
            this.captureStream.start();
        }
        catch (CaptureException captureException) {
            logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
            throw new IOException("" + (Object)((Object)captureException));
        }
        this.started.setValue(true);
    }

    public void stop() throws IOException {
        logger.fine("civil: stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.captureStream != null) {
                this.captureStream.stop();
            }
        }
        catch (CaptureException captureException) {
            logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
            throw new IOException("" + (Object)((Object)captureException));
        }
        finally {
            this.started.setValue(false);
        }
    }

    private class VideoFrameRateControl
    implements FrameRateControl,
    Owned {
        private VideoFrameRateControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public float getFrameRate() {
            return DataSource.this.frameRate;
        }

        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public float getPreferredFrameRate() {
            return -1.0f;
        }

        public float setFrameRate(float f) {
            try {
                return f;
            }
            catch (Exception exception) {
                return -1.0f;
            }
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            if (DataSource.this.outputVideoFormat == null) {
                logger.warning("outputVideoFormat == null, video format unknown.");
            }
            return DataSource.this.outputVideoFormat;
        }

        void notifyTransferHandler() {
            BufferTransferHandler bufferTransferHandler = (BufferTransferHandler)DataSource.this.transferHandlerHolder.getObject();
            if (bufferTransferHandler != null) {
                bufferTransferHandler.transferData(this);
            }
        }

        public void read(Buffer buffer) throws IOException {
            if (!DataSource.this.started.getValue()) {
                buffer.setOffset(0);
                buffer.setLength(0);
                buffer.setDiscard(true);
                return;
            }
            try {
                Buffer buffer2 = (Buffer)DataSource.this.jitterBuffer.get();
                buffer.setFlags(buffer2.getFlags());
                buffer.setOffset(0);
                buffer.setData(buffer2.getData());
                buffer.setLength(buffer2.getLength());
                buffer.setFormat(buffer2.getFormat());
                buffer.setSequenceNumber(buffer2.getSequenceNumber());
                buffer.setRtpTimeStamp(buffer2.getRtpTimeStamp());
                buffer.setHeaderExtension(buffer2.getHeaderExtension());
                buffer.setTimeStamp(buffer2.getTimeStamp());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            DataSource.this.transferHandlerHolder.setObject(bufferTransferHandler);
        }
    }

    private class MyCaptureObserver
    implements CaptureObserver {
        private long sequenceNumber = 0L;

        private MyCaptureObserver() {
        }

        public void onError(CaptureStream captureStream, CaptureException captureException) {
            logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewImage(CaptureStream captureStream, Image image) {
            if (DataSource.this.started.getValue()) {
                long l = System.nanoTime();
                javax.media.format.VideoFormat videoFormat = DataSource.convertCivilFormat(image.getFormat());
                if (null == DataSource.this.jitterBuffer) {
                    DataSource.this.jitterBuffer = new RingBuffer(DataSource.this.jitterbuflen);
                    logger.fine("jitterbuflen=" + DataSource.this.jitterbuflen);
                }
                Object object = DataSource.this.currentBufferMutex;
                synchronized (object) {
                    DataSource.this.currentBuffer = new Buffer();
                    DataSource.this.currentBuffer.setFlags(32896);
                    DataSource.this.currentBuffer.setOffset(0);
                    DataSource.this.currentBuffer.setData(image.getBytes());
                    DataSource.this.currentBuffer.setLength(image.getBytes().length);
                    DataSource.this.currentBuffer.setFormat(videoFormat);
                    DataSource.this.currentBuffer.setSequenceNumber(++this.sequenceNumber);
                    DataSource.this.currentBuffer.setTimeStamp(l);
                }
                if (null != DataSource.this.pushBufferStream && (object = (BufferTransferHandler)DataSource.this.transferHandlerHolder.getObject()) != null && !DataSource.this.jitterBuffer.put(DataSource.this.currentBuffer)) {
                    DataSource.this.pushBufferStream.notifyTransferHandler();
                }
                long l2 = l;
                if (-1L == DataSource.this.lastTimestamp) {
                    DataSource.this.lastTimestamp = l2;
                }
                DataSource.this.framesProcessed++;
                if (l2 - DataSource.this.lastTimestamp > 1000000000L) {
                    float f = (float)(l2 - DataSource.this.lastTimestamp) / 1000000.0f;
                    DataSource.this.frameRate = (float)DataSource.this.framesProcessed * (1000.0f / f);
                    DataSource.this.framesProcessed = 0;
                    DataSource.this.lastTimestamp = l2;
                }
            }
        }
    }

    private class JitterBufferControl
    implements BufferControl,
    Owned {
        private JitterBufferControl() {
        }

        public long getBufferLength() {
            return DataSource.this.jitterbuflen;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long setBufferLength(long l) {
            boolean bl = false;
            if (DataSource.this.started.getValue()) {
                bl = true;
                try {
                    DataSource.this.stop();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                }
            }
            DataSource.this.jitterbuflen = (int)l;
            DataSource.this.jitterBuffer = new RingBuffer(DataSource.this.jitterbuflen);
            logger.fine("jitterbuflen=" + DataSource.this.jitterbuflen);
            if (bl) {
                try {
                    DataSource.this.start();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                }
            }
            return DataSource.this.jitterbuflen;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public long setMinimumThreshold(long l) {
            return -1L;
        }
    }

    private class CivilFormatControl
    implements FormatControl,
    Owned {
        private CivilFormatControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            try {
                VideoFormat videoFormat = DataSource.this.captureStream.getVideoFormat();
                return DataSource.convertCivilFormat(videoFormat);
            }
            catch (Exception exception) {
                return DataSource.this.outputVideoFormat;
            }
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public Format[] getSupportedFormats() {
            if (DataSource.this.captureStream != null && DataSource.this.connected) {
                try {
                    List list = DataSource.this.captureStream.enumVideoFormats();
                    Format[] formatArray = new Format[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        formatArray[i] = DataSource.convertCivilFormat((VideoFormat)list.get(i));
                    }
                    return formatArray;
                }
                catch (CaptureException captureException) {
                    logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
                }
            }
            return new Format[0];
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean bl) {
            DataSource.this.enabled = bl;
        }

        public Format setFormat(Format format) {
            block4: {
                if (!(format instanceof javax.media.format.VideoFormat)) {
                    return null;
                }
                try {
                    if (!DataSource.this.connected || DataSource.this.started.getValue() || null == DataSource.this.captureStream) break block4;
                    List list = DataSource.this.captureStream.enumVideoFormats();
                    for (int i = 0; i < list.size(); ++i) {
                        javax.media.format.VideoFormat videoFormat = DataSource.convertCivilFormat((VideoFormat)list.get(i));
                        if (!format.matches(videoFormat)) continue;
                        DataSource.this.captureStream.setVideoFormat((VideoFormat)list.get(i));
                        DataSource.this.outputVideoFormat = videoFormat;
                        break;
                    }
                }
                catch (CaptureException captureException) {
                    logger.log(Level.WARNING, "" + (Object)((Object)captureException), captureException);
                }
            }
            return DataSource.this.outputVideoFormat;
        }
    }
}

