/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.protocol.CloneableSourceStreamAdapter;
import net.sf.fmj.media.protocol.SourceStreamSlave;

class SuperCloneableDataSource
extends DataSource {
    protected DataSource input;
    public CloneableSourceStreamAdapter[] streamsAdapters;
    public SourceStream[] streams = null;
    private Vector clones = new Vector();

    SuperCloneableDataSource(DataSource dataSource) {
        this.input = dataSource;
        SourceStream[] sourceStreamArray = null;
        if (dataSource instanceof PullDataSource) {
            sourceStreamArray = ((PullDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PushDataSource) {
            sourceStreamArray = ((PushDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PullBufferDataSource) {
            sourceStreamArray = ((PullBufferDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PushBufferDataSource) {
            sourceStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        }
        this.streamsAdapters = new CloneableSourceStreamAdapter[sourceStreamArray.length];
        for (int i = 0; i < sourceStreamArray.length; ++i) {
            this.streamsAdapters[i] = new CloneableSourceStreamAdapter(sourceStreamArray[i]);
        }
    }

    public void connect() throws IOException {
        this.input.connect();
    }

    DataSource createClone() {
        DataSource dataSource = this.input instanceof PullDataSource || this.input instanceof PushDataSource ? new PushDataSourceSlave() : new PushBufferDataSourceSlave();
        this.clones.addElement(dataSource);
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return dataSource;
    }

    public void disconnect() {
        this.input.disconnect();
    }

    public String getContentType() {
        return this.input.getContentType();
    }

    public Object getControl(String string) {
        return this.input.getControl(string);
    }

    public Object[] getControls() {
        return this.input.getControls();
    }

    public Time getDuration() {
        return this.input.getDuration();
    }

    public void start() throws IOException {
        this.input.start();
    }

    public void stop() throws IOException {
        this.input.stop();
    }

    class PushDataSourceSlave
    extends PushDataSource {
        PushSourceStream[] streams = null;

        public PushDataSourceSlave() {
            this.streams = new PushSourceStream[SuperCloneableDataSource.this.streamsAdapters.length];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = (PushSourceStream)SuperCloneableDataSource.this.streamsAdapters[i].createSlave();
            }
        }

        public void connect() throws IOException {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).connect();
            }
        }

        public void disconnect() {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).disconnect();
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public Object getControl(String string) {
            return SuperCloneableDataSource.this.input.getControl(string);
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        public PushSourceStream[] getStreams() {
            return this.streams;
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }
    }

    class PushBufferDataSourceSlave
    extends PushBufferDataSource {
        PushBufferStream[] streams = null;

        public PushBufferDataSourceSlave() {
            this.streams = new PushBufferStream[SuperCloneableDataSource.this.streamsAdapters.length];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = (PushBufferStream)SuperCloneableDataSource.this.streamsAdapters[i].createSlave();
            }
        }

        public void connect() throws IOException {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).connect();
            }
        }

        public void disconnect() {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).disconnect();
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public Object getControl(String string) {
            return SuperCloneableDataSource.this.input.getControl(string);
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }
    }
}

