/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.Streamable;

public class DelegateDataSource
extends PushBufferDataSource
implements Streamable {
    protected String contentType = "raw";
    protected PushBufferDataSource master;
    protected DelegateStream[] streams;
    protected boolean started = false;
    protected boolean connected = false;

    public DelegateDataSource(Format[] formatArray) {
        this.streams = new DelegateStream[formatArray.length];
        for (int i = 0; i < formatArray.length; ++i) {
            this.streams[i] = new DelegateStream(formatArray[i]);
        }
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.master != null) {
            this.master.connect();
        }
        this.connected = true;
    }

    public void disconnect() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.master != null) {
            this.master.disconnect();
        }
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public Object getControl(String string) {
        if (this.master != null) {
            return this.master.getControl(string);
        }
        return null;
    }

    public Object[] getControls() {
        if (this.master != null) {
            return this.master.getControls();
        }
        return new Object[0];
    }

    public Time getDuration() {
        if (this.master != null) {
            return this.master.getDuration();
        }
        return Duration.DURATION_UNKNOWN;
    }

    public MediaLocator getLocator() {
        if (this.master != null) {
            return this.master.getLocator();
        }
        return null;
    }

    public DataSource getMaster() {
        return this.master;
    }

    public PushBufferStream[] getStreams() {
        return this.streams;
    }

    public boolean isPrefetchable() {
        return false;
    }

    public void setMaster(PushBufferDataSource pushBufferDataSource) throws IOException {
        int n;
        this.master = pushBufferDataSource;
        PushBufferStream[] pushBufferStreamArray = pushBufferDataSource.getStreams();
        for (n = 0; n < pushBufferStreamArray.length; ++n) {
            for (int i = 0; i < this.streams.length; ++i) {
                if (!this.streams[i].getFormat().matches(pushBufferStreamArray[n].getFormat())) continue;
                this.streams[i].setMaster(pushBufferStreamArray[n]);
            }
        }
        for (n = 0; n < pushBufferStreamArray.length; ++n) {
            if (this.streams[n].getMaster() != null) continue;
            Log.error("DelegateDataSource: cannot not find a matching track from the master with this format: " + this.streams[n].getFormat());
        }
        if (this.connected) {
            this.master.connect();
        }
        if (this.started) {
            this.master.start();
        }
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        if (this.master != null) {
            this.master.start();
        }
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.connected || !this.started) {
            return;
        }
        if (this.master != null) {
            this.master.stop();
        }
        this.started = false;
    }

    class DelegateStream
    implements PushBufferStream,
    BufferTransferHandler {
        Format format;
        PushBufferStream master;
        BufferTransferHandler th;

        public DelegateStream(Format format) {
            this.format = format;
        }

        public boolean endOfStream() {
            if (this.master != null) {
                return this.master.endOfStream();
            }
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            if (this.master != null) {
                return this.master.getContentDescriptor();
            }
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            if (this.master != null) {
                return this.master.getContentLength();
            }
            return -1L;
        }

        public Object getControl(String string) {
            if (this.master != null) {
                return this.master.getControl(string);
            }
            return null;
        }

        public Object[] getControls() {
            if (this.master != null) {
                return this.master.getControls();
            }
            return new Object[0];
        }

        public Format getFormat() {
            if (this.master != null) {
                return this.master.getFormat();
            }
            return this.format;
        }

        public PushBufferStream getMaster() {
            return this.master;
        }

        public void read(Buffer buffer) throws IOException {
            if (this.master != null) {
                this.master.read(buffer);
            }
            throw new IOException("No data available");
        }

        public void setMaster(PushBufferStream pushBufferStream) {
            this.master = pushBufferStream;
            pushBufferStream.setTransferHandler(this);
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.th = bufferTransferHandler;
        }

        public void transferData(PushBufferStream pushBufferStream) {
            if (this.th != null) {
                this.th.transferData(pushBufferStream);
            }
        }
    }
}

