/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.parser.RawPullStreamParser;

public class RawPullBufferParser
extends RawPullStreamParser {
    static final String NAME = "Raw pull stream parser";

    public String getName() {
        return NAME;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PullBufferStream)this.streams[i]);
        }
    }

    public void setSource(DataSource dataSource) throws IncompatibleSourceException, IOException {
        if (!(dataSource instanceof PullBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        SourceStream[] sourceStreamArray = ((PullBufferDataSource)dataSource).getStreams();
        if (sourceStreamArray == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (sourceStreamArray.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(sourceStreamArray)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = sourceStreamArray;
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PullBufferStream;
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullBufferStream pbs;
        boolean enabled = true;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);

        public FrameTrack(Demultiplexer demultiplexer, PullBufferStream pullBufferStream) {
            this.pbs = pullBufferStream;
            this.format = pullBufferStream.getFormat();
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        public void readFrame(Buffer buffer) {
            if (buffer.getData() == null) {
                buffer.setData(new byte[500]);
            }
            try {
                this.pbs.read(buffer);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }
    }
}

