/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.ModuleListener;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.StateTransistor;

public abstract class BasicModule
implements Module,
StateTransistor {
    protected Registry inputConnectors = new Registry();
    protected Registry outputConnectors = new Registry();
    protected InputConnector[] inputConnectorsArray;
    protected OutputConnector[] outputConnectorsArray;
    protected int protocol = 0;
    protected String name = null;
    protected ModuleListener moduleListener;
    protected BasicController controller;
    protected boolean resetted = false;
    protected boolean prefetchFailed = false;

    public void abortPrefetch() {
    }

    public void abortRealize() {
    }

    public boolean canRun() {
        int n;
        for (n = 0; n < this.inputConnectorsArray.length; ++n) {
            if (this.inputConnectorsArray[n].isValidBufferAvailable()) continue;
            return false;
        }
        for (n = 0; n < this.outputConnectorsArray.length; ++n) {
            if (this.outputConnectorsArray[n].isEmptyBufferAvailable()) continue;
            return false;
        }
        return true;
    }

    public void connectorPushed(InputConnector inputConnector) {
        this.process();
    }

    public void doClose() {
    }

    public void doDealloc() {
    }

    public void doFailedPrefetch() {
    }

    public void doFailedRealize() {
    }

    public boolean doPrefetch() {
        this.resetted = false;
        return true;
    }

    public boolean doRealize() {
        return true;
    }

    public void doSetMediaTime(Time time) {
    }

    public float doSetRate(float f) {
        return f;
    }

    public void doStart() {
        this.resetted = false;
    }

    public void doStop() {
    }

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " error");
    }

    public Object getControl(String string) {
        return null;
    }

    public final BasicController getController() {
        return this.controller;
    }

    public Object[] getControls() {
        return null;
    }

    public InputConnector getInputConnector(String string) {
        return (InputConnector)this.inputConnectors.get(string);
    }

    public String[] getInputConnectorNames() {
        return this.inputConnectors.getNames();
    }

    public long getLatency() {
        return ((PlaybackEngine)this.controller).getLatency();
    }

    public long getMediaNanoseconds() {
        return this.controller.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.controller.getMediaTime();
    }

    public final String getName() {
        return this.name;
    }

    public OutputConnector getOutputConnector(String string) {
        return (OutputConnector)this.outputConnectors.get(string);
    }

    public String[] getOutputConnectorNames() {
        return this.outputConnectors.getNames();
    }

    public int getProtocol() {
        return this.protocol;
    }

    public final int getState() {
        return this.controller.getState();
    }

    public final boolean isInterrupted() {
        return this.controller == null ? false : this.controller.isInterrupted();
    }

    public boolean isThreaded() {
        return true;
    }

    public boolean prefetchFailed() {
        return this.prefetchFailed;
    }

    protected abstract void process();

    public void registerInputConnector(String string, InputConnector inputConnector) {
        this.inputConnectors.put(string, inputConnector);
        inputConnector.setModule(this);
    }

    public void registerOutputConnector(String string, OutputConnector outputConnector) {
        this.outputConnectors.put(string, outputConnector);
        outputConnector.setModule(this);
    }

    public void reset() {
        this.resetted = true;
    }

    public final void setController(BasicController basicController) {
        this.controller = basicController;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public void setModuleListener(ModuleListener moduleListener) {
        this.moduleListener = moduleListener;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProtocol(int n) {
        int n2;
        this.protocol = n;
        Connector[] connectorArray = this.inputConnectors.getConnectors();
        for (n2 = 0; n2 < connectorArray.length; ++n2) {
            connectorArray[n2].setProtocol(n);
        }
        connectorArray = this.outputConnectors.getConnectors();
        for (n2 = 0; n2 < connectorArray.length; ++n2) {
            connectorArray[n2].setProtocol(n);
        }
    }

    protected boolean verifyBuffer(Buffer buffer) {
        if (buffer.isDiscard()) {
            return true;
        }
        Object object = buffer.getData();
        if (buffer.getLength() < 0) {
            System.err.println("warning: data length shouldn't be negative: " + buffer.getLength());
        }
        if (object == null) {
            System.err.println("warning: data buffer is null");
            if (buffer.getLength() != 0) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but data buffer is null!");
                return false;
            }
        } else if (object instanceof byte[]) {
            if (buffer.getLength() > ((byte[])object).length) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((byte[])object).length);
                return false;
            }
        } else if (object instanceof int[] && buffer.getLength() > ((int[])object).length) {
            System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((int[])object).length);
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Registry
    extends Hashtable<String, Connector> {
        Connector def = null;

        Registry() {
        }

        Object get(String string) {
            if (string == null) {
                return this.def;
            }
            return super.get(string);
        }

        Connector[] getConnectors() {
            Enumeration enumeration = this.elements();
            Connector[] connectorArray = new Connector[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                connectorArray[i] = (Connector)enumeration.nextElement();
            }
            return connectorArray;
        }

        String[] getNames() {
            Enumeration enumeration = this.keys();
            String[] stringArray = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                stringArray[i] = (String)enumeration.nextElement();
            }
            return stringArray;
        }

        @Override
        public Connector put(String string, Connector connector) {
            if (this.containsKey(string)) {
                throw new RuntimeException("Connector '" + string + "' already exists in Module '" + BasicModule.this.getClass().getName() + "::" + string + "'");
            }
            if (this.def == null) {
                this.def = connector;
            }
            return super.put(string, connector);
        }
    }
}

