/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import com.lti.utils.synchronization.CloseableThread;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.RateChangeEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;

public class StopTimeMonitor
extends CloseableThread
implements ControllerListener {
    private boolean wokenUp;
    private AbstractController controller;

    public StopTimeMonitor(AbstractController abstractController, String string) {
        this.setName(string);
        this.controller = abstractController;
        abstractController.addControllerListener(this);
        this.setDaemon(true);
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof StopTimeChangeEvent || controllerEvent instanceof RateChangeEvent || controllerEvent instanceof MediaTimeSetEvent || controllerEvent instanceof StartEvent || controllerEvent instanceof StopEvent && !(controllerEvent instanceof DeallocateEvent)) {
            this.wokenUp = true;
            this.notifyAll();
        }
    }

    private long getWaitTime(Time time) throws ClockStoppedException {
        long l = this.controller.mapToTimeBase(time).getNanoseconds();
        long l2 = this.controller.getTimeBase().getNanoseconds();
        return (l - l2) / 1000000L;
    }

    private synchronized void monitorStopTime() throws InterruptedException {
        while (!this.isClosing()) {
            long l;
            Time time;
            while (this.controller.getState() != 600 || (time = this.controller.getStopTime()) == Clock.RESET) {
                this.wait();
            }
            this.wokenUp = false;
            try {
                l = this.getWaitTime(time);
            }
            catch (ClockStoppedException clockStoppedException) {
                continue;
            }
            if (l > 0L) {
                this.wait(l);
            }
            if (this.wokenUp) continue;
            this.controller.stopAtTime();
            this.controller.setStopTime(Clock.RESET);
        }
    }

    public void run() {
        try {
            this.monitorStopTime();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setClosed();
    }
}

