/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public final class JNIUtils {
    private static final Pattern DYLIB_PATTERN = Pattern.compile("\\.dylib$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String libname, ClassLoader classLoader) {
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError ulerr) {
            File embedded;
            libname = System.mapLibraryName(libname);
            if (Platform.isMac()) {
                libname = DYLIB_PATTERN.matcher(libname).replaceFirst(".jnilib");
            }
            try {
                embedded = Native.extractFromResourcePath((String)("/" + Platform.RESOURCE_PREFIX + "/" + libname), (ClassLoader)classLoader);
            }
            catch (IOException ioex) {
                throw ulerr;
            }
            try {
                System.load(embedded.getAbsolutePath());
            }
            finally {
                if (embedded.getName().startsWith("jna") && !embedded.delete()) {
                    embedded.deleteOnExit();
                }
            }
        }
    }

    private JNIUtils() {
    }
}

