/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

import org.jitsi.impl.neomedia.ArrayIOUtils;

public class AudioLevelCalculator {
    public static final byte MAX_AUDIO_LEVEL = 0;
    public static final byte MIN_AUDIO_LEVEL = 127;

    public static byte calculateAudioLevel(byte[] samples, int offset, int length) {
        double db;
        double rms = 0.0;
        while (offset < length) {
            double sample = ArrayIOUtils.readShort(samples, offset);
            rms += (sample /= 32767.0) * sample;
            offset += 2;
        }
        int sampleCount = length / 2;
        double d = rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        if (rms > 0.0) {
            db = 20.0 * Math.log10(rms);
            if ((db = -db) > 127.0) {
                db = 127.0;
            } else if (db < 0.0) {
                db = 0.0;
            }
        } else {
            db = 127.0;
        }
        return (byte)db;
    }
}

