/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.TimeoutEvent;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.RTPMediaThread;
import net.sf.fmj.media.rtp.util.SSRCTable;

public class SSRCCacheCleaner
implements Runnable {
    private static final long RUN_INTERVAL = 5000L;
    private static final int TIMEOUT_MULTIPLIER = 5;
    private final SSRCCache cache;
    private boolean killed;
    private long lastCleaned;
    private int[] ssrcs;
    private final StreamSynch streamSynch;
    private final RTPMediaThread thread;

    public SSRCCacheCleaner(SSRCCache cache, StreamSynch streamSynch) {
        this.cache = cache;
        this.streamSynch = streamSynch;
        this.killed = false;
        this.lastCleaned = -1L;
        this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
        this.thread.useControlPriority();
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - void declaration
     */
    private long cleannow(long time) {
        SSRCInfo ourssrc = this.cache.ourssrc;
        long timeUntilNextProcess = Long.MAX_VALUE;
        if (ourssrc == null) {
            return timeUntilNextProcess;
        }
        double reportInterval = this.cache.calcReportInterval(ourssrc.sender, true);
        SSRCTable<SSRCInfo> infos = this.cache.cache;
        this.ssrcs = infos.keysToArray(this.ssrcs);
        for (int ssrc : this.ssrcs) {
            SSRCInfo info;
            if (ssrc == 0 || (info = infos.get(ssrc)) == null || info.ours) continue;
            if (info.byeReceived) {
                void var17_16;
                ReceiveStream receiveStream;
                long byeTimeout = 1000L - time + info.byeTime;
                if (byeTimeout > 0L) {
                    if (byeTimeout >= timeUntilNextProcess) continue;
                    timeUntilNextProcess = byeTimeout;
                    continue;
                }
                info.byeTime = 0L;
                info.byeReceived = false;
                this.cache.remove(info.ssrc);
                this.streamSynch.remove(info.ssrc);
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (info instanceof RecvSSRCInfo) {
                    receiveStream = (ReceiveStream)((Object)info);
                } else {
                    if (!(info instanceof PassiveSSRCInfo)) continue;
                    receiveStream = null;
                }
                ByeEvent ev = new ByeEvent(this.cache.sm, sourceInfo, (ReceiveStream)var17_16, info.byereason, sourceInfo != null && sourceInfo.getStreamCount() == 0);
                this.cache.eventhandler.postEvent(ev);
                continue;
            }
            if (!((double)info.lastHeardFrom + reportInterval <= (double)time)) continue;
            if (!info.inactivesent) {
                ReceiveStream receiveStream;
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (info instanceof ReceiveStream) {
                    receiveStream = (ReceiveStream)((Object)info);
                } else {
                    if (!((double)info.lastHeardFrom + reportInterval * 5.0 <= (double)time)) continue;
                    receiveStream = null;
                }
                InactiveReceiveStreamEvent ev = new InactiveReceiveStreamEvent(this.cache.sm, sourceInfo, receiveStream, sourceInfo != null && sourceInfo.getStreamCount() == 1);
                this.cache.eventhandler.postEvent(ev);
                info.quiet = true;
                info.inactivesent = true;
                info.setAlive(false);
                continue;
            }
            if (info.lastHeardFrom + 5000L > time) continue;
            this.cache.remove(info.ssrc);
            RTPSourceInfo sourceInfo = info.sourceInfo;
            TimeoutEvent ev = new TimeoutEvent(this.cache.sm, sourceInfo, info instanceof ReceiveStream ? (ReceiveStream)((Object)info) : null, sourceInfo != null && sourceInfo.getStreamCount() == 0);
            this.cache.eventhandler.postEvent(ev);
        }
        return timeUntilNextProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long timeout = Long.MAX_VALUE;
        while (true) {
            long now;
            SSRCCacheCleaner sSRCCacheCleaner = this;
            synchronized (sSRCCacheCleaner) {
                if (this.killed) {
                    break;
                }
                now = System.currentTimeMillis();
                long l = timeout = this.lastCleaned == -1L ? 0L : Math.min(this.lastCleaned + 5000L - now, timeout);
                if (timeout > 0L) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    timeout = Long.MAX_VALUE;
                    continue;
                }
                this.lastCleaned = now;
            }
            try {
                timeout = this.cleannow(now);
                if (timeout > 0L) continue;
                timeout = Long.MAX_VALUE;
            }
            catch (Exception ex) {
                timeout = Long.MAX_VALUE;
                ex.printStackTrace();
            }
        }
    }

    public synchronized void setClean() {
        this.lastCleaned = -1L;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.killed = true;
        this.notifyAll();
    }
}

