/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rewriting;

import java.util.Map;
import java.util.WeakHashMap;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.RTPPacket;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.RTPPacketParserEx;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.function.RTPGenerator;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rewriting.SsrcRewriter;

public class SsrcRewritingEngine
implements TransformEngine {
    private final VideoChannel videoChannel;
    private Map<VideoChannel, SsrcRewriter> peerChannelEngines = new WeakHashMap<VideoChannel, SsrcRewriter>();
    private Object peerChannelEnginesSyncRoot = new Object();
    private boolean enabled = false;
    private final SinglePacketTransformer rtpTransformer = new SinglePacketTransformer(){

        public RawPacket transform(RawPacket pkt) {
            RTPPacket rtpPacket;
            if (!SsrcRewritingEngine.this.enabled) {
                return pkt;
            }
            Conference conference = SsrcRewritingEngine.this.videoChannel.getContent().getConference();
            if (conference == null) {
                return pkt;
            }
            RTPPacketParserEx parser = new RTPPacketParserEx();
            try {
                rtpPacket = parser.parse(pkt);
            }
            catch (BadFormatException e) {
                return pkt;
            }
            Channel channel = conference.findChannelByReceiveSSRC((long)rtpPacket.ssrc & 0xFFFFFFFFL, MediaType.VIDEO);
            if (channel == null || !(channel instanceof VideoChannel)) {
                return pkt;
            }
            VideoChannel peerVideoChannel = (VideoChannel)channel;
            SsrcRewriter ssrcRewriter = SsrcRewritingEngine.this.getOrCreatePeerChannelEngine(peerVideoChannel);
            rtpPacket = ssrcRewriter.transform(rtpPacket);
            RTPGenerator generator = new RTPGenerator();
            return generator.apply(rtpPacket);
        }

        public RawPacket reverseTransform(RawPacket pkt) {
            return pkt;
        }
    };
    private final SinglePacketTransformer rtcpTransformer = new SinglePacketTransformer(){

        public RawPacket transform(RawPacket pkt) {
            if (!SsrcRewritingEngine.this.enabled) {
                return pkt;
            }
            return pkt;
        }

        public RawPacket reverseTransform(RawPacket pkt) {
            if (!SsrcRewritingEngine.this.enabled) {
                return pkt;
            }
            return pkt;
        }
    };

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SsrcRewriter getOrCreatePeerChannelEngine(VideoChannel peerVideoChannel) {
        Object object = this.peerChannelEnginesSyncRoot;
        synchronized (object) {
            if (!this.peerChannelEngines.containsKey(peerVideoChannel)) {
                this.peerChannelEngines.put(peerVideoChannel, new SsrcRewriter());
            }
            SsrcRewriter ssrcRewriter = this.peerChannelEngines.get(peerVideoChannel);
            ssrcRewriter.setCurrentRewriteSsrc(peerVideoChannel.getSimulcastManager().getSimulcastLayers().first().getPrimarySSRC());
            return ssrcRewriter;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SsrcRewritingEngine(VideoChannel videoChannel) {
        this.videoChannel = videoChannel;
    }

    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }
}

