/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PacketBodyBuffer {
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private static final int[] SEPARATOR = new int[]{192, 128};
    private static final String SEPARATOR_STRING = new String(new byte[]{-64, -128});
    private String charEncoding = System.getProperty("openymsg.network.charEncoding", "UTF-8");

    void addString(String s) throws UnsupportedEncodingException, IOException {
        this.baos.write(s.getBytes(this.charEncoding));
        this.baos.write(SEPARATOR[0]);
        this.baos.write(SEPARATOR[1]);
    }

    public void addElement(String key, String value) throws UnsupportedEncodingException, IOException {
        this.addString(key);
        this.addString(value);
    }

    synchronized byte[] getBuffer() {
        return this.baos.toByteArray();
    }

    void reset() {
        this.baos.reset();
    }

    public String toString() {
        return new String(this.baos.toByteArray()).replace(SEPARATOR_STRING, " ");
    }
}

