/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import java.util.Locale;
import javax.sip.InvalidArgumentException;
import javax.sip.header.AcceptLanguageHeader;

public final class AcceptLanguage
extends ParametersHeader
implements AcceptLanguageHeader {
    private static final long serialVersionUID = -4473982069737324919L;
    protected String languageRange;

    public AcceptLanguage() {
        super("Accept-Language");
    }

    protected String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.languageRange != null) {
            stringBuffer.append(this.languageRange);
        }
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";").append(this.parameters.encode());
        }
        return stringBuffer.toString();
    }

    public String getLanguageRange() {
        return this.languageRange;
    }

    public float getQValue() {
        if (!this.hasParameter("q")) {
            return -1.0f;
        }
        return ((Float)this.parameters.getValue("q")).floatValue();
    }

    public boolean hasQValue() {
        return this.hasParameter("q");
    }

    public void removeQValue() {
        this.removeParameter("q");
    }

    public void setLanguageRange(String string) {
        this.languageRange = string.trim();
    }

    public void setQValue(float f) throws InvalidArgumentException {
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new InvalidArgumentException("qvalue out of range!");
        }
        if (f == -1.0f) {
            this.removeParameter("q");
        } else {
            this.setParameter(new NameValue("q", new Float(f)));
        }
    }

    public Locale getAcceptLanguage() {
        if (this.languageRange == null) {
            return null;
        }
        int n = this.languageRange.indexOf(45);
        if (n >= 0) {
            return new Locale(this.languageRange.substring(0, n), this.languageRange.substring(n + 1));
        }
        return new Locale(this.languageRange);
    }

    public void setAcceptLanguage(Locale locale) {
        this.languageRange = "".equals(locale.getCountry()) ? locale.getLanguage() : locale.getLanguage() + '-' + locale.getCountry();
    }
}

