/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

public class HostAddress {
    private String fqdn;
    private int port;
    private Exception exception;

    public HostAddress(String fqdn) {
        if (fqdn == null) {
            throw new IllegalArgumentException("FQDN is null");
        }
        this.fqdn = fqdn.charAt(fqdn.length() - 1) == '.' ? fqdn.substring(0, fqdn.length() - 1) : fqdn;
        this.port = 5222;
    }

    public HostAddress(String fqdn, int port) {
        this(fqdn);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("DNS SRV records weight must be a 16-bit unsiged integer (i.e. between 0-65535. Port was: " + port);
        }
        this.port = port;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public int getPort() {
        return this.port;
    }

    public void setException(Exception e) {
        this.exception = e;
    }

    public String toString() {
        return this.fqdn + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAddress)) {
            return false;
        }
        HostAddress address = (HostAddress)o;
        if (!this.fqdn.equals(address.fqdn)) {
            return false;
        }
        return this.port == address.port;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.fqdn.hashCode();
        return result * 37 + this.port;
    }

    public String getErrorMessage() {
        String error = this.exception == null ? "No error logged" : this.exception.getMessage();
        return this.toString() + " Exception: " + error;
    }
}

