/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.RecoverTxnOperation;
import com.hazelcast.transaction.impl.RecoveredTransaction;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.util.ExceptionUtil;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RecoverAllTransactionsRequest
extends InvocationClientRequest {
    @Override
    public void invoke() {
        ClientEngine clientEngine = this.getClientEngine();
        ClusterService clusterService = clientEngine.getClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        TransactionManagerServiceImpl service = (TransactionManagerServiceImpl)this.getService();
        List<Future<SerializableCollection>> futures = this.recoverTransactions(memberList);
        HashSet<Data> xids = new HashSet<Data>();
        for (Future<SerializableCollection> future : futures) {
            try {
                SerializableCollection collectionWrapper = future.get(5000L, TimeUnit.MILLISECONDS);
                for (Data data : collectionWrapper) {
                    RecoveredTransaction rt = (RecoveredTransaction)this.serializationService.toObject(data);
                    service.addClientRecoveredTransaction(rt);
                    xids.add(this.serializationService.toData(rt.getXid()));
                }
            }
            catch (MemberLeftException e) {
                ILogger logger = clientEngine.getLogger(RecoverAllTransactionsRequest.class);
                logger.warning("Member left while recovering: " + e);
            }
            catch (Throwable e) {
                this.handleException(clientEngine, e);
            }
        }
        ClientEndpoint endpoint = this.getEndpoint();
        endpoint.sendResponse(new SerializableCollection(xids), this.getCallId());
    }

    private List<Future<SerializableCollection>> recoverTransactions(Collection<MemberImpl> memberList) {
        ArrayList<Future<SerializableCollection>> futures = new ArrayList<Future<SerializableCollection>>(memberList.size());
        for (MemberImpl member : memberList) {
            RecoverTxnOperation op = new RecoverTxnOperation();
            InternalCompletableFuture f = this.createInvocationBuilder("hz:core:txManagerService", (Operation)op, member.getAddress()).invoke();
            futures.add(f);
        }
        return futures;
    }

    private void handleException(ClientEngine clientEngine, Throwable e) {
        Throwable cause = this.getCause(e);
        if (!(cause instanceof TargetNotMemberException)) {
            throw ExceptionUtil.rethrow(e);
        }
        ILogger logger = clientEngine.getLogger(RecoverAllTransactionsRequest.class);
        logger.warning("Member left while recovering: " + cause);
    }

    private Throwable getCause(Throwable e) {
        if (e instanceof ExecutionException && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    @Override
    @Deprecated
    public String getServiceName() {
        return "hz:core:txManagerService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

