/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl.client;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.topic.impl.TopicPortableHook;
import java.io.IOException;

public class PortableMessage
implements Portable {
    private Data message;
    private long publishTime;
    private String uuid;

    public PortableMessage() {
    }

    public PortableMessage(Data message, long publishTime, String uuid) {
        this.message = message;
        this.publishTime = publishTime;
        this.uuid = uuid;
    }

    public Data getMessage() {
        return this.message;
    }

    public long getPublishTime() {
        return this.publishTime;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return TopicPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeLong("pt", this.publishTime);
        writer.writeUTF("u", this.uuid);
        this.message.writeData(writer.getRawDataOutput());
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.publishTime = reader.readLong("pt");
        this.uuid = reader.readUTF("u");
        this.message = new Data();
        this.message.readData(reader.getRawDataInput());
    }
}

