/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LoadAllOperation
extends AbstractMapOperation
implements PartitionAwareOperation {
    private List<Data> keys;
    private boolean replaceExistingValues;

    public LoadAllOperation() {
        this.keys = Collections.emptyList();
    }

    public LoadAllOperation(String name, List<Data> keys, boolean replaceExistingValues) {
        super(name);
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        RecordStore recordStore = this.mapService.getMapServiceContext().getRecordStore(partitionId, this.name);
        this.keys = this.selectThisPartitionsKeys(this.keys);
        recordStore.loadAllFromStore(this.keys, this.replaceExistingValues);
    }

    private List<Data> selectThisPartitionsKeys(Collection<Data> keys) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        InternalPartitionService partitionService = mapServiceContext.getNodeEngine().getPartitionService();
        int partitionId = this.getPartitionId();
        ArrayList<Data> dataKeys = null;
        for (Data key : keys) {
            if (partitionId != partitionService.getPartitionId(key)) continue;
            if (dataKeys == null) {
                dataKeys = new ArrayList<Data>();
            }
            dataKeys.add(key);
        }
        if (dataKeys == null) {
            return Collections.emptyList();
        }
        return dataKeys;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int size = this.keys.size();
        out.writeInt(size);
        for (Data key : this.keys) {
            key.writeData(out);
        }
        out.writeBoolean(this.replaceExistingValues);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > 0) {
            this.keys = new ArrayList<Data>(size);
        }
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.keys.add(data);
        }
        this.replaceExistingValues = in.readBoolean();
    }
}

