/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.operation.AddIndexOperationFactory;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;

public class MapAddIndexRequest
extends AllPartitionsClientRequest
implements Portable,
SecureRequest {
    private String name;
    private String attribute;
    private boolean ordered;

    public MapAddIndexRequest() {
    }

    public MapAddIndexRequest(String name, String attribute, boolean ordered) {
        this.name = name;
        this.attribute = attribute;
        this.ordered = ordered;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("a", this.attribute);
        writer.writeBoolean("o", this.ordered);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.attribute = reader.readUTF("a");
        this.ordered = reader.readBoolean("o");
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new AddIndexOperationFactory(this.name, this.attribute, this.ordered);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "index");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addIndex";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.attribute, this.ordered};
    }
}

