/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.AbstractRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class SendRvIcbm
extends AbstractRvIcbm {
    private final String sn;

    protected SendRvIcbm(SnacPacket snacPacket) {
        super(6, snacPacket);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = this.getChannelData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.processRvTlvs(immutableTlvChain);
    }

    public SendRvIcbm(String string, long l, int n, long l2, CapabilityBlock capabilityBlock, LiveWritable liveWritable) {
        super(6, l, n, l2, capabilityBlock, liveWritable);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
    }

    public SendRvIcbm(String string, long l, long l2, RvCommand rvCommand) {
        super(6, l, l2, rvCommand);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
    }

    public final String getScreenname() {
        return this.sn;
    }

    protected final void writeChannelData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        this.writeRvTlvs(outputStream);
    }
}

