/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.SIPObject;

public class RequestLine
extends SIPObject {
    private static final long serialVersionUID = -3286426172326043129L;
    protected GenericURI uri;
    protected String method;
    protected String sipVersion;

    public RequestLine() {
        this.sipVersion = "SIP/2.0";
    }

    public void setSIPVersion(String string) {
        this.sipVersion = string;
    }

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.method != null) {
            stringBuffer.append(this.method);
            stringBuffer.append(" ");
        }
        if (this.uri != null) {
            stringBuffer.append(this.uri.encode());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.sipVersion + "\r\n");
        return stringBuffer.toString();
    }

    public GenericURI getUri() {
        return this.uri;
    }

    public RequestLine(GenericURI genericURI, String string) {
        this.uri = genericURI;
        this.method = string;
        this.sipVersion = "SIP/2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public void setUri(GenericURI genericURI) {
        this.uri = genericURI;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setSipVersion(String string) {
        this.sipVersion = string;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < this.sipVersion.length() && this.sipVersion.charAt(i) != '.'; ++i) {
            if (bl) {
                string = string == null ? "" + this.sipVersion.charAt(i) : string + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            bl = true;
        }
        return string;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (bl) {
                string = string == null ? "" + this.sipVersion.charAt(i) : string + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            bl = true;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        RequestLine requestLine = (RequestLine)object;
        try {
            bl = this.method.equals(requestLine.method) && this.uri.equals(requestLine.uri) && this.sipVersion.equals(requestLine.sipVersion);
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public Object clone() {
        RequestLine requestLine = (RequestLine)super.clone();
        if (this.uri != null) {
            requestLine.uri = (GenericURI)this.uri.clone();
        }
        return requestLine;
    }
}

