/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

abstract class Message {
    ArrayList arguments;
    String body;
    int type = 0;
    Integer transactionID = new Integer(-1);
    static final String CVR_STRING = "0x0409 winnt 5.1 i386 MSNMSGR 5.0.0540 MSMSGS ";
    static final int ACK = 1;
    static final int ADD = 2;
    static final int ADG = 3;
    static final int ANS = 4;
    static final int BLP = 5;
    static final int BPR = 6;
    static final int BYE = 7;
    static final int CAL = 8;
    static final int CHG = 9;
    static final int CHL = 10;
    static final int FLN = 11;
    static final int GTC = 12;
    static final int ILN = 13;
    static final int TWN = 14;
    static final int IRO = 15;
    static final int JOI = 16;
    static final int LSG = 17;
    static final int LST = 18;
    static final int MSG = 19;
    static final int NAK = 20;
    static final int NLN = 21;
    static final int OUT = 22;
    static final int PRP = 23;
    static final int QRY = 24;
    static final int REA = 25;
    static final int REG = 26;
    static final int REM = 27;
    static final int RMG = 28;
    static final int RNG = 29;
    static final int SYN = 30;
    static final int USR = 31;
    static final int VER = 32;
    static final int XFR = 33;
    static final int CVR = 34;
    static final int SDC = 35;
    static final int PNG = 36;
    static final int QNG = 37;
    static final int ERROR = 38;
    static HashMap commandMap = new HashMap();

    protected Message() {
        this.arguments = new ArrayList();
    }

    boolean hasBody() {
        return this.type == 19;
    }

    void setBody(String body) {
        this.body = body;
    }

    String getBody() {
        return this.body;
    }

    int getTransactionID() {
        return this.transactionID;
    }

    int getType() {
        return this.type;
    }

    static int parseCommand(String rawCommand) throws ParseException {
        String trimmedCommand = rawCommand.trim();
        if (commandMap.containsKey(trimmedCommand)) {
            return (Integer)commandMap.get(trimmedCommand);
        }
        try {
            Integer.parseInt(trimmedCommand);
            return 38;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Message.parseCommand() - " + trimmedCommand + " is not a valid command.", 0);
        }
    }

    static String commandToString(int commandType) {
        switch (commandType) {
            case 1: {
                return "ACK";
            }
            case 2: {
                return "ADD";
            }
            case 3: {
                return "ADG";
            }
            case 4: {
                return "ANS";
            }
            case 5: {
                return "BLP";
            }
            case 6: {
                return "BPR";
            }
            case 7: {
                return "BYE";
            }
            case 8: {
                return "CAL";
            }
            case 9: {
                return "CHG";
            }
            case 10: {
                return "CHL";
            }
            case 11: {
                return "FLN";
            }
            case 12: {
                return "GTC";
            }
            case 13: {
                return "ILN";
            }
            case 14: {
                return "TWN";
            }
            case 15: {
                return "IRO";
            }
            case 16: {
                return "JOI";
            }
            case 17: {
                return "LSG";
            }
            case 18: {
                return "LST";
            }
            case 19: {
                return "MSG";
            }
            case 20: {
                return "NAK";
            }
            case 21: {
                return "NLN";
            }
            case 22: {
                return "OUT";
            }
            case 23: {
                return "PRP";
            }
            case 24: {
                return "QRY";
            }
            case 25: {
                return "REA";
            }
            case 26: {
                return "REG";
            }
            case 27: {
                return "REM";
            }
            case 28: {
                return "RMG";
            }
            case 29: {
                return "RNG";
            }
            case 30: {
                return "SYN";
            }
            case 31: {
                return "USR";
            }
            case 32: {
                return "VER";
            }
            case 33: {
                return "XFR";
            }
            case 34: {
                return "CVR";
            }
            case 35: {
                return "SDC";
            }
            case 36: {
                return "PNG";
            }
            case 37: {
                return "QNG";
            }
            case 38: {
                return "ERROR";
            }
        }
        return "NOT_A_COMMAND";
    }

    public String toString() {
        String argumentsString = "";
        String bodyString = "";
        String commandString = this.getType() == 0 ? "[No Command] " : Message.commandToString(this.type);
        String transactionIDString = this.transactionID == -1 ? "[No Transaction ID] " : this.transactionID.toString();
        argumentsString = this.arguments == null ? "[No Arguments] " : this.arguments.toString();
        if (this.hasBody()) {
            bodyString = this.body;
        }
        return commandString + transactionIDString + argumentsString + "\n" + bodyString;
    }

    static {
        commandMap.put("ACK", new Integer(1));
        commandMap.put("ADD", new Integer(2));
        commandMap.put("ADG", new Integer(3));
        commandMap.put("ANS", new Integer(4));
        commandMap.put("BLP", new Integer(5));
        commandMap.put("BPR", new Integer(6));
        commandMap.put("BYE", new Integer(7));
        commandMap.put("CAL", new Integer(8));
        commandMap.put("CHG", new Integer(9));
        commandMap.put("CHL", new Integer(10));
        commandMap.put("FLN", new Integer(11));
        commandMap.put("GTC", new Integer(12));
        commandMap.put("ILN", new Integer(13));
        commandMap.put("TWN", new Integer(14));
        commandMap.put("IRO", new Integer(15));
        commandMap.put("JOI", new Integer(16));
        commandMap.put("LSG", new Integer(17));
        commandMap.put("LST", new Integer(18));
        commandMap.put("MSG", new Integer(19));
        commandMap.put("NAK", new Integer(20));
        commandMap.put("NLN", new Integer(21));
        commandMap.put("OUT", new Integer(22));
        commandMap.put("PRP", new Integer(23));
        commandMap.put("QRY", new Integer(24));
        commandMap.put("REA", new Integer(25));
        commandMap.put("REG", new Integer(26));
        commandMap.put("REM", new Integer(27));
        commandMap.put("RMG", new Integer(28));
        commandMap.put("RNG", new Integer(29));
        commandMap.put("SYN", new Integer(30));
        commandMap.put("USR", new Integer(31));
        commandMap.put("VER", new Integer(32));
        commandMap.put("XFR", new Integer(33));
        commandMap.put("CVR", new Integer(34));
        commandMap.put("SDC", new Integer(35));
        commandMap.put("PNG", new Integer(36));
        commandMap.put("QNG", new Integer(37));
    }
}

