/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;

public class AcctInfoRequest
extends AcctCommand {
    public static final int TYPE_SN = 1;
    public static final int TYPE_EMAIL = 17;
    public static final int TYPE_SOMETHING = 19;
    public static final int SUBTYPE_DEFAULT = 0;
    private final int type;
    private final int subType;

    protected AcctInfoRequest(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.type = BinaryTools.getUShort(byteBlock, 0);
        this.subType = BinaryTools.getUShort(byteBlock, 2);
    }

    public AcctInfoRequest(int n) {
        this(n, 0);
    }

    public AcctInfoRequest(int n, int n2) {
        super(2);
        DefensiveTools.checkRange(n, "type", 0);
        DefensiveTools.checkRange(n2, "subType", 0);
        this.type = n;
        this.subType = n2;
    }

    public final int getType() {
        return this.type;
    }

    public final int getSubType() {
        return this.subType;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        BinaryTools.writeUShort(outputStream, this.subType);
    }

    public String toString() {
        return "InfoRequest: type=" + this.type + ", subtype=" + this.subType;
    }
}

