/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;

public abstract class SnacCmdFactoryList {
    private Map<CmdType, SnacCmdFactory> factories = new HashMap<CmdType, SnacCmdFactory>();

    public final synchronized void register(CmdType cmdType, SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(cmdType, "type");
        if (!snacCmdFactory.getSupportedTypes().contains(cmdType)) {
            return;
        }
        this.factories.put(cmdType, snacCmdFactory);
    }

    public final synchronized void registerAll(SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(snacCmdFactory, "factory");
        for (CmdType cmdType : snacCmdFactory.getSupportedTypes()) {
            this.factories.put(cmdType, snacCmdFactory);
        }
    }

    public final synchronized void unregister(CmdType cmdType, SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(cmdType, "type");
        SnacCmdFactory snacCmdFactory2 = this.factories.get(cmdType);
        if (snacCmdFactory2 == snacCmdFactory) {
            this.factories.remove(cmdType);
        }
    }

    public final synchronized void unregisterAll(SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(snacCmdFactory, "factory");
        Collection<SnacCmdFactory> collection = this.factories.values();
        while (collection.remove(snacCmdFactory)) {
        }
    }

    public final synchronized void unregisterAll() {
        this.factories.clear();
    }

    public final synchronized SnacCmdFactory getFactory(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        return this.factories.get(cmdType);
    }
}

