/*
 * Decompiled with CFR 0.152.
 */
package org.jugbb.ant.iconcodegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconCodeGenerator {
    private static List<String> retrieveFileExtensions(String imageExtensions) {
        ArrayList<String> listExtensions = new ArrayList<String>();
        if (imageExtensions == null || imageExtensions.isEmpty()) {
            imageExtensions = "png,jpg,gif";
        }
        StringTokenizer st = new StringTokenizer(imageExtensions, ",; |");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            ext = ext.replace('*', ' ');
            ext = ext.replace('.', ' ');
            listExtensions.add(ext.trim().toUpperCase());
        }
        return listExtensions;
    }

    private static List<File> collectPictureFiles(File directory, List<String> listExtensions) {
        ArrayList<File> listFiles = new ArrayList<File>();
        File[] allFiles = directory.listFiles();
        if (allFiles != null) {
            for (File f : allFiles) {
                String fExt = IconCodeGenerator.getFileExtension(f);
                if (fExt == null || !listExtensions.contains(fExt.toUpperCase())) continue;
                listFiles.add(f);
            }
        }
        return listFiles;
    }

    private static String getFileExtension(File f) {
        String ext = null;
        int pos = f.getName().lastIndexOf(46);
        if (pos > 0 && pos < f.getName().length() - 1) {
            ext = f.getName().substring(pos + 1);
        }
        return ext;
    }

    private static File getImageDir(File sourceDir, String packageName) {
        File f = new File(sourceDir + "/" + packageName.replace('.', '/'));
        return f;
    }

    public static void createIconProvider(File sourceDir, String packageName, String fileExtensions, String encoding) throws IOException {
        if (!sourceDir.exists()) {
            throw new IOException("Source directory " + sourceDir.getAbsolutePath() + " does not exists.");
        }
        File targetDir = IconCodeGenerator.getImageDir(sourceDir, packageName);
        if (!targetDir.exists()) {
            throw new IOException("Package " + packageName + " does not exists in source dir " + sourceDir.getAbsolutePath());
        }
        List<File> imageFiles = IconCodeGenerator.collectPictureFiles(targetDir, IconCodeGenerator.retrieveFileExtensions(fileExtensions));
        if (imageFiles.isEmpty()) {
            throw new IOException("No images found in dir: " + targetDir);
        }
        String code = IconCodeGenerator.createIconProviderCode(sourceDir, packageName, imageFiles);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(targetDir, "ApplicationIcons.java")), encoding));
        bw.write(code);
        bw.flush();
        bw.close();
    }

    public static void createImageProvider(File sourceDir, String packageName, String fileExtensions, String encoding) throws IOException {
        if (!sourceDir.exists()) {
            throw new IOException("Source directory " + sourceDir.getAbsolutePath() + " does not exists.");
        }
        File targetDir = IconCodeGenerator.getImageDir(sourceDir, packageName);
        if (!targetDir.exists()) {
            throw new IOException("Package " + packageName + " does not exists in source dir " + sourceDir.getAbsolutePath());
        }
        List<File> imageFiles = IconCodeGenerator.collectPictureFiles(targetDir, IconCodeGenerator.retrieveFileExtensions(fileExtensions));
        if (imageFiles.isEmpty()) {
            throw new IOException("No images found in dir: " + targetDir);
        }
        String code = IconCodeGenerator.createImageProviderCode(sourceDir, packageName, imageFiles);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(targetDir, "ApplicationImages.java")), encoding));
        bw.write(code);
        bw.flush();
        bw.close();
    }

    public static String createIconProviderCode(File sourceDir, String packageName, List<File> imageFiles) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(IconCodeGenerator.createIconClassStartCode(packageName));
        for (File f : imageFiles) {
            sb.append(IconCodeGenerator.createIconEntryCode(f, packageName));
        }
        sb.append(IconCodeGenerator.createIconCreateMethodCode());
        sb.append("\n}");
        return sb.toString();
    }

    public static String createImageProviderCode(File sourceDir, String packageName, List<File> imageFiles) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(IconCodeGenerator.createImageClassStartCode(packageName));
        for (File f : imageFiles) {
            sb.append(IconCodeGenerator.createImageEntryCode(f, packageName));
        }
        sb.append(IconCodeGenerator.createImageCreateMethodCode());
        sb.append("\n}");
        return sb.toString();
    }

    private static String createIndention(int level) {
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    private static String createIconClassStartCode(String packageName) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(packageName);
        sb.append(";\n\n");
        sb.append("import javax.swing.ImageIcon;\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" * Class contains images as static variables.\n");
        sb.append(" * This class is generated by the IconCodeGenerator\n");
        sb.append(" *\n");
        sb.append(" * author: " + System.getProperty("user.name") + "\n");
        sb.append(" * created at: " + new Date() + "\n");
        sb.append(" */\n");
        sb.append("public class ApplicationIcons {\n\n");
        return sb.toString();
    }

    private static String createImageClassStartCode(String packageName) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(packageName);
        sb.append(";\n\n");
        sb.append("import java.awt.Image;\n");
        sb.append("import java.awt.Toolkit;\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" * Class contains images as static variables.\n");
        sb.append(" * This class is generated by the IconCodeGenerator\n");
        sb.append(" *\n");
        sb.append(" * author: " + System.getProperty("user.name") + "\n");
        sb.append(" * created at: " + new Date() + "\n");
        sb.append(" */\n");
        sb.append("public class ApplicationImages {\n\n");
        return sb.toString();
    }

    private static String createIconEntryCode(File iconFile, String packageName) {
        StringBuilder sb = new StringBuilder();
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("public static final ImageIcon ");
        sb.append(iconFile.getName().replace('.', '_').toUpperCase());
        sb.append(" = createIcon(\"/");
        sb.append(packageName.replace('.', '/'));
        sb.append("/");
        sb.append(iconFile.getName());
        sb.append("\");\n");
        return sb.toString();
    }

    private static String createImageEntryCode(File iconFile, String packageName) {
        StringBuilder sb = new StringBuilder();
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("public static final Image ");
        sb.append(iconFile.getName().replace('.', '_').toUpperCase());
        sb.append(" = createImage(\"/");
        sb.append(packageName.replace('.', '/'));
        sb.append("/");
        sb.append(iconFile.getName());
        sb.append("\");\n");
        return sb.toString();
    }

    private static String createIconCreateMethodCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("private static ImageIcon createIcon(String iconName) {\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("ImageIcon icon = null;\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("try {\n");
        sb.append(IconCodeGenerator.createIndention(3));
        sb.append("icon = new ImageIcon(ApplicationIcons.class.getResource(iconName));\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("} catch (Exception e) {\n");
        sb.append(IconCodeGenerator.createIndention(3));
        sb.append("System.err.println(\"unable to load icon: \" + iconName);\n");
        sb.append(IconCodeGenerator.createIndention(3));
        sb.append("icon = new ImageIcon();\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("}\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("return icon;\n");
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("}\n");
        return sb.toString();
    }

    private static String createImageCreateMethodCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("private static Image createImage(String imageName) {\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("Image image = null;\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("try {\n");
        sb.append(IconCodeGenerator.createIndention(3));
        sb.append("image = Toolkit.getDefaultToolkit().getImage(ApplicationImages.class.getResource(imageName));\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("} catch (Exception e) {\n");
        sb.append(IconCodeGenerator.createIndention(3));
        sb.append("System.err.println(\"unable to load image: \" + imageName);\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("}\n");
        sb.append(IconCodeGenerator.createIndention(2));
        sb.append("return image;\n");
        sb.append(IconCodeGenerator.createIndention(1));
        sb.append("}\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("ImageCodeGenerator\n");
            System.out.println("Usage: java -jar imageCodeGen.jar <path-to-source-root> <package-with-images> [<list of image extensions>]");
            System.exit(0);
        }
        String pathToSource = null;
        String packageName = null;
        StringBuffer listExts = new StringBuffer();
        block6: for (int i = 0; i < args.length; ++i) {
            switch (i) {
                case 0: {
                    pathToSource = args[i];
                    continue block6;
                }
                case 1: {
                    packageName = args[i];
                    continue block6;
                }
                default: {
                    listExts.append(args[i]);
                }
            }
        }
        try {
            System.out.println("Start creating java code...");
            System.out.println("source path=" + pathToSource);
            System.out.println("icon package=" + packageName);
            System.out.println("list image file extensions: " + listExts.toString());
            if (pathToSource == null) {
                System.err.println("pathToSource must be defined!");
                System.exit(2);
            }
            if (packageName == null) {
                System.err.println("packageName must be defined!");
                System.exit(2);
            }
            IconCodeGenerator.createIconProvider(new File(pathToSource), packageName, listExts.toString(), "UTF-8");
            System.out.println("You will find a new class " + packageName + ".ApplicationIcons in your project.");
            System.out.println("Done.");
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            System.err.println("End.");
        }
    }
}

