/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class UncommentAction
extends Action {
    private DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
    private boolean wellFormed = false;

    public UncommentAction() {
        this.dfactory.setNamespaceAware(true);
    }

    @Override
    public boolean apply(Node node) throws Exception {
        if (node instanceof Comment) {
            Node parent;
            Comment comment = (Comment)node;
            System.out.println("Uncommenting " + comment.getData());
            Document commentDoc = this.readXml(comment.getData());
            Node newnode = this.doc.importNode(commentDoc.getDocumentElement(), true);
            if (!this.wellFormed) {
                DocumentFragment frag = this.doc.createDocumentFragment();
                NodeList children = newnode.getChildNodes();
                int c = 0;
                while (c < children.getLength()) {
                    frag.appendChild(children.item(c));
                }
                newnode = frag;
            }
            if ((parent = node.getParentNode()) == null) {
                System.err.println("Attempt to insert after root node");
                return false;
            }
            parent.insertBefore(newnode, node.getNextSibling());
            parent.removeChild(comment);
            return true;
        }
        throw new BuildException(node + " is not a comment");
    }

    private Document readXml(String xml) throws Exception {
        DocumentBuilder db = this.getBuilder();
        try {
            Document doc = db.parse(new InputSource(new StringReader(xml)));
            this.wellFormed = true;
            return doc;
        }
        catch (SAXParseException e) {
            xml = "<XMLTASK>" + xml + "</XMLTASK>";
            Document doc = db.parse(new InputSource(new StringReader(xml)));
            this.wellFormed = false;
            return doc;
        }
    }

    private DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilder db = this.dfactory.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                System.err.println(e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) {
            }

            @Override
            public void warning(SAXParseException e) {
                System.err.println(e.getMessage());
            }
        });
        return db;
    }
}

