/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Codebook;

public abstract class LspQuant
implements Codebook {
    public static final int MAX_LSP_SIZE = 20;

    protected LspQuant() {
    }

    public abstract void quant(float[] var1, float[] var2, int var3, Bits var4);

    public abstract void unquant(float[] var1, int var2, Bits var3);

    protected void unpackPlus(float[] lsp, int[] tab, Bits bits, float k, int ti, int li) {
        int id = bits.unpack(6);
        for (int i = 0; i < ti; ++i) {
            int n = i + li;
            lsp[n] = lsp[n] + k * (float)tab[id * ti + i];
        }
    }

    protected static int lsp_quant(float[] x, int xs, int[] cdbk, int nbVec, int nbDim) {
        int j;
        float best_dist = 0.0f;
        int best_id = 0;
        int ptr = 0;
        for (int i = 0; i < nbVec; ++i) {
            float dist = 0.0f;
            for (j = 0; j < nbDim; ++j) {
                float tmp = x[xs + j] - (float)cdbk[ptr++];
                dist += tmp * tmp;
            }
            if (!(dist < best_dist) && i != 0) continue;
            best_dist = dist;
            best_id = i;
        }
        for (j = 0; j < nbDim; ++j) {
            int n = xs + j;
            x[n] = x[n] - (float)cdbk[best_id * nbDim + j];
        }
        return best_id;
    }

    protected static int lsp_weight_quant(float[] x, int xs, float[] weight, int ws, int[] cdbk, int nbVec, int nbDim) {
        int j;
        float best_dist = 0.0f;
        int best_id = 0;
        int ptr = 0;
        for (int i = 0; i < nbVec; ++i) {
            float dist = 0.0f;
            for (j = 0; j < nbDim; ++j) {
                float tmp = x[xs + j] - (float)cdbk[ptr++];
                dist += weight[ws + j] * tmp * tmp;
            }
            if (!(dist < best_dist) && i != 0) continue;
            best_dist = dist;
            best_id = i;
        }
        for (j = 0; j < nbDim; ++j) {
            int n = xs + j;
            x[n] = x[n] - (float)cdbk[best_id * nbDim + j];
        }
        return best_id;
    }
}

