/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.Base64;

public class SASLDigestMD5Mechanism
extends SASLMechanism {
    public SASLDigestMD5Mechanism(SASLAuthentication saslAuthentication) {
        super(saslAuthentication);
    }

    protected String getName() {
        return "DIGEST-MD5";
    }

    public void challengeReceived(String challenge) throws IOException {
        StringBuilder stanza = new StringBuilder();
        byte[] response = challenge != null ? this.sc.evaluateChallenge(Base64.decode(challenge)) : this.sc.evaluateChallenge(null);
        String authenticationText = null;
        if (response != null && (authenticationText = Base64.encodeBytes(response, 8)).equals("")) {
            authenticationText = "=";
        }
        if (authenticationText != null) {
            stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            stanza.append(authenticationText);
            stanza.append("</response>");
        } else {
            stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" />");
        }
        this.getSASLAuthentication().send(new SASLMechanism.Response(this, authenticationText));
    }
}

