/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.FetchData;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Source;

class ValueExtractor {
    private String[] varNames;
    private int reduceFactor = 1;
    private int[] tPos;
    private long[] steps;
    private long[][] timestamps;
    private double[][][] dsValues;

    ValueExtractor(String[] names, FetchData[] values, int reduceFactor) {
        this.varNames = names;
        this.reduceFactor = reduceFactor;
        this.tPos = new int[values.length];
        this.steps = new long[values.length];
        this.timestamps = new long[values.length][];
        this.dsValues = new double[values.length][][];
        for (int i = 0; i < this.timestamps.length; ++i) {
            if (values[i] == null) continue;
            this.timestamps[i] = values[i].getTimestamps();
            this.dsValues[i] = values[i].getValues();
            if (this.timestamps[i].length < 2) continue;
            this.steps[i] = this.timestamps[i][1] - this.timestamps[i][0];
        }
    }

    int prepareSources(Source[] sources, int offset) {
        int tblPos = offset;
        for (int i = 0; i < this.dsValues.length; ++i) {
            if (this.dsValues[i] == null) continue;
            for (int x = 0; x < this.dsValues[i].length; ++x) {
                sources[tblPos++].setFetchedStep(this.steps[i]);
            }
        }
        return tblPos;
    }

    int extract(long timestamp, Source[] sources, int row, int offset) throws RrdException {
        int tblPos = offset;
        for (int i = 0; i < this.dsValues.length; ++i) {
            int x;
            int j;
            if (this.dsValues[i] == null) continue;
            int tIndex = this.tPos[i];
            double[] nValue = new double[this.dsValues[i].length];
            int[] vValue = new int[nValue.length];
            for (j = 0; j < nValue.length; ++j) {
                nValue[j] = Double.NaN;
            }
            for (j = 0; j < this.reduceFactor && this.timestamps[i][tIndex] <= timestamp; ++j) {
                block9: for (x = 0; x < this.dsValues[i].length; ++x) {
                    if (Double.isNaN(this.dsValues[i][x][tIndex])) continue;
                    int n = x;
                    vValue[n] = vValue[n] + 1;
                    if (Double.isNaN(nValue[x])) {
                        nValue[x] = this.dsValues[i][x][tIndex];
                        continue;
                    }
                    switch (i) {
                        case 0: {
                            int n2 = x;
                            nValue[n2] = nValue[n2] + this.dsValues[i][x][tIndex];
                            continue block9;
                        }
                        case 1: {
                            nValue[x] = Util.max(nValue[x], this.dsValues[i][x][tIndex]);
                            continue block9;
                        }
                        case 2: {
                            nValue[x] = Util.min(nValue[x], this.dsValues[i][x][tIndex]);
                            continue block9;
                        }
                        case 3: {
                            nValue[x] = this.dsValues[i][x][tIndex];
                        }
                    }
                }
                ++tIndex;
            }
            if (j == 0 && row > 0) {
                sources[tblPos++].set(row, timestamp, Double.POSITIVE_INFINITY);
            } else {
                for (x = 0; x < this.dsValues[i].length; ++x) {
                    if (i == 0) {
                        int n = x;
                        nValue[n] = nValue[n] / (double)vValue[x];
                    }
                    sources[tblPos++].set(row, timestamp, nValue[x]);
                }
            }
            this.tPos[i] = tIndex;
        }
        return tblPos;
    }

    String[] getNames() {
        return this.varNames;
    }
}

