/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.SimpleDateFormat;
import org.jrobin.graph.TimeAxisUnit;
import org.jrobin.graph.TimeMarker;

class TimeGrid {
    private long startTime;
    private long endTime;
    private TimeAxisUnit tAxis;

    TimeGrid(long startTime, long endTime, TimeAxisUnit tAxis, int firstDayOfWeek) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.tAxis = tAxis;
        this.setTimeAxis(firstDayOfWeek);
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    TimeMarker[] getTimeMarkers() {
        return this.tAxis.getTimeMarkers(this.startTime, this.endTime);
    }

    long getMajorGridWidth() {
        return this.tAxis.getMajorGridWidth();
    }

    boolean centerLabels() {
        return this.tAxis.getCenterLabels();
    }

    private void setTimeAxis(int firstDayOfWeek) {
        if (this.tAxis != null) {
            return;
        }
        double days = (double)(this.endTime - this.startTime) / 86400.0;
        this.tAxis = days <= 0.03125 ? new TimeAxisUnit(1, 1, 1, 5, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.08333333333333333 ? new TimeAxisUnit(1, 5, 1, 10, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.125 ? new TimeAxisUnit(1, 5, 1, 20, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.20833333333333334 ? new TimeAxisUnit(1, 10, 1, 30, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.4166666666666667 ? new TimeAxisUnit(1, 15, 2, 1, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.625 ? new TimeAxisUnit(1, 30, 2, 2, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 0.8333333333333334 ? new TimeAxisUnit(2, 1, 2, 1, new SimpleDateFormat("HH"), true, firstDayOfWeek) : (days <= 1.5 ? new TimeAxisUnit(2, 1, 2, 4, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 2.0 ? new TimeAxisUnit(2, 2, 2, 6, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days <= 3.0 ? new TimeAxisUnit(2, 3, 2, 12, new SimpleDateFormat("HH:mm"), false, firstDayOfWeek) : (days < 8.0 ? new TimeAxisUnit(2, 6, 3, 1, new SimpleDateFormat("EEE dd"), true, firstDayOfWeek) : (days <= 14.0 ? new TimeAxisUnit(2, 12, 3, 1, new SimpleDateFormat("dd"), true, firstDayOfWeek) : (days <= 43.0 ? new TimeAxisUnit(3, 1, 4, 1, new SimpleDateFormat("'week' ww"), true, firstDayOfWeek) : (days <= 157.0 ? new TimeAxisUnit(4, 1, 4, 1, new SimpleDateFormat("ww"), true, firstDayOfWeek) : new TimeAxisUnit(5, 1, 5, 1, new SimpleDateFormat("MMM"), true, firstDayOfWeek))))))))))))));
    }
}

