/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Pdef;
import org.jrobin.graph.Plottable;
import org.jrobin.graph.Sdef;

public class RrdExportDef
implements Serializable {
    public static final int STRICT_IMPLICIT_OFF = 0;
    public static final int STRICT_IMPLICIT_ON = 1;
    public static final int STRICT_EXPLICIT_OFF = 2;
    public static final int STRICT_EXPLICIT_ON = 3;
    private long endTime = Util.getTime();
    private long startTime = Util.getTime() - 86400L;
    private long resolution = 1L;
    private int strict = 0;
    private int numSdefs = 0;
    private int numDefs = 0;
    protected FetchSourceList fetchSources = new FetchSourceList(10);
    protected ArrayList pdefList = new ArrayList(10);
    protected ArrayList cdefList = new ArrayList(10);
    protected ArrayList exportList = new ArrayList(10);
    protected ArrayList edefList = new ArrayList(3);

    public RrdExportDef() {
    }

    public RrdExportDef(long startTime, long endTime) throws RrdException {
        this.setTimePeriod(startTime, endTime);
    }

    public RrdExportDef(Date start, Date end) throws RrdException {
        this.setTimePeriod(start, end);
    }

    public RrdExportDef(GregorianCalendar start, GregorianCalendar end) throws RrdException {
        this.setTimePeriod(start, end);
    }

    public void setTimePeriod(long startTime, long endTime) throws RrdException {
        if (startTime < 0L || endTime != 0L && endTime <= startTime) {
            throw new RrdException("Invalid start/end time: " + startTime + "/" + endTime);
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void setTimePeriod(Date start, Date end) throws RrdException {
        this.setTimePeriod(start.getTime() / 1000L, end.getTime() / 1000L);
    }

    public void setTimePeriod(GregorianCalendar start, GregorianCalendar end) throws RrdException {
        this.setTimePeriod(start.getTime(), end.getTime());
    }

    public void setResolution(long resolution) {
        this.resolution = resolution;
    }

    public void datasource(String name, String file, String dsName, String consolFunc) throws RrdException {
        this.fetchSources.add(name, file, dsName, consolFunc);
        ++this.numDefs;
    }

    public void datasource(String name, String file, String dsName, String consolFunc, String backend) throws RrdException {
        this.fetchSources.add(name, file, dsName, consolFunc, backend);
        ++this.numDefs;
    }

    public void setDatasources(FetchSourceList datasourceList) {
        this.fetchSources = datasourceList;
        this.numDefs = this.fetchSources.defCount();
    }

    public void datasource(String name, String rpn) {
        this.cdefList.add(new Cdef(name, rpn));
    }

    public void datasource(String name, String defName, String consolFunc) throws RrdException {
        this.cdefList.add(new Sdef(name, defName, consolFunc));
        ++this.numSdefs;
    }

    public void datasource(String name, Plottable plottable) {
        this.pdefList.add(new Pdef(name, plottable));
    }

    public void datasource(String name, Plottable plottable, int index) {
        this.pdefList.add(new Pdef(name, plottable, index));
    }

    public void datasource(String name, Plottable plottable, String sourceName) {
        this.pdefList.add(new Pdef(name, plottable, sourceName));
    }

    public void addExportData(ExportData edata) {
        this.edefList.add(edata);
    }

    public void export(String name) {
        this.export(name, "");
    }

    public void export(String name, String legend) {
        if (this.strict == 0) {
            this.strict = 1;
        }
        this.exportList.add(new String[]{name, legend});
    }

    public void setStrictExport(boolean strict) {
        this.strict = strict ? 3 : 2;
    }

    public void exportXmlTemplate(OutputStream stream) {
        int i;
        XmlWriter xml = new XmlWriter(stream);
        xml.startTag("rrd_export_def");
        xml.startTag("span");
        xml.writeTag("start", this.getStartTime());
        xml.writeTag("end", this.getEndTime());
        xml.closeTag();
        xml.startTag("options");
        if (this.resolution > 1L) {
            xml.writeTag("resolution", this.resolution);
        }
        xml.writeTag("strict_export", this.strict == 1 || this.strict == 3 ? "true" : "false");
        xml.closeTag();
        xml.startTag("datasources");
        for (i = 0; i < this.fetchSources.size(); ++i) {
            this.fetchSources.get(i).exportXml(xml);
        }
        for (i = 0; i < this.cdefList.size(); ++i) {
            Cdef cdef = (Cdef)this.cdefList.get(i);
            cdef.exportXml(xml);
        }
        xml.closeTag();
        xml.startTag("exports");
        String[][] list = this.getExportDatasources();
        for (int i2 = 0; i2 < list.length; ++i2) {
            xml.startTag("export");
            xml.writeTag("datasource", list[i2][0]);
            xml.writeTag("legend", list[i2][1]);
            xml.closeTag();
        }
        xml.closeTag();
        xml.closeTag();
        xml.flush();
        xml.flush();
    }

    public String getXmlTemplate() {
        return this.exportXmlTemplate();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.exportXmlTemplate(outputStream);
        return outputStream.toString();
    }

    public void exportXmlTemplate(String filePath) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(filePath, false);
        this.exportXmlTemplate(outputStream);
        outputStream.close();
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getEndTime() {
        return this.endTime;
    }

    protected long getResolution() {
        return this.resolution;
    }

    protected int getNumDefs() {
        return this.numDefs;
    }

    protected Cdef[] getCdefs() {
        return this.cdefList.toArray(new Cdef[0]);
    }

    protected Pdef[] getPdefs() {
        return this.pdefList.toArray(new Pdef[0]);
    }

    protected ExportData[] getExportData() {
        return this.edefList.toArray(new ExportData[0]);
    }

    protected int getNumSdefs() {
        return this.numSdefs;
    }

    protected FetchSourceList getFetchSources() {
        return this.fetchSources;
    }

    protected boolean isStrict() {
        return this.strict == 1 || this.strict == 3;
    }

    protected String[][] getExportDatasources() {
        return (String[][])this.exportList.toArray((T[])new String[0][2]);
    }
}

