/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ValueMarker;

class ValueAxisUnit {
    private double gridStep = 2.0;
    private double labelStep = 10.0;

    ValueAxisUnit(double gridStep, double labelStep) {
        this.gridStep = gridStep;
        this.labelStep = labelStep;
    }

    double getGridStep() {
        return this.gridStep;
    }

    double getLabelStep() {
        return this.labelStep;
    }

    ValueMarker[] getValueMarkers(double lower, double upper) {
        double mod;
        double minPoint = 0.0;
        double majPoint = 0.0;
        if (lower > 0.0) {
            minPoint = lower;
            mod = lower % this.labelStep;
            majPoint = mod > 0.0 ? lower + (this.labelStep - mod) : lower;
        } else if (lower < 0.0) {
            minPoint = lower;
            mod = lower % this.labelStep;
            majPoint = Math.abs(mod) > 0.0 ? lower - mod : lower;
        }
        ArrayList<ValueMarker> markerList = new ArrayList<ValueMarker>();
        while (minPoint <= upper && majPoint <= upper) {
            if (minPoint < majPoint) {
                markerList.add(new ValueMarker(minPoint, false));
                minPoint = this.round(minPoint + this.gridStep);
                continue;
            }
            if (minPoint == majPoint) {
                markerList.add(new ValueMarker(majPoint, true));
                minPoint = this.round(minPoint + this.gridStep);
                majPoint = this.round(majPoint + this.labelStep);
                continue;
            }
            markerList.add(new ValueMarker(majPoint, true));
            majPoint = this.round(majPoint + this.labelStep);
        }
        while (minPoint <= upper) {
            markerList.add(new ValueMarker(minPoint, false));
            minPoint = this.round(minPoint + this.gridStep);
        }
        while (majPoint <= upper) {
            markerList.add(new ValueMarker(majPoint, true));
            majPoint = this.round(majPoint + this.labelStep);
        }
        return markerList.toArray(new ValueMarker[0]);
    }

    double getNiceLower(double ovalue) {
        double gridFactor = 1.0;
        double mGridFactor = 1.0;
        double gridStep = this.gridStep;
        double mGridStep = this.labelStep;
        while (gridStep < 10.0) {
            gridStep *= 10.0;
            gridFactor *= 10.0;
        }
        while (mGridStep < 10.0) {
            mGridStep *= 10.0;
            mGridFactor *= 10.0;
        }
        int sign = ovalue > 0.0 ? 1 : -1;
        long lGridStep = new Double(gridStep).longValue();
        long lmGridStep = new Double(mGridStep).longValue();
        long lValue = new Double((double)sign * ovalue * gridFactor).longValue();
        long lmValue = new Double((double)sign * ovalue * mGridFactor).longValue();
        long lMod = lValue % lGridStep;
        long lmMod = lmValue % lmGridStep;
        if (ovalue < 0.0) {
            if ((double)lmMod > mGridStep * 0.5) {
                return (double)((long)sign * lmValue + lmMod - lmGridStep) / mGridFactor;
            }
            if (lMod > 0L) {
                return (double)((long)sign * lValue + lMod - lGridStep) / gridFactor;
            }
            return (double)((long)sign * lValue - lGridStep) / gridFactor;
        }
        if ((double)lmMod < mGridStep * 0.5) {
            return (double)((long)sign * lmValue - lmMod) / mGridFactor;
        }
        if (lMod > 0L) {
            return (double)((long)sign * lValue - lMod) / gridFactor;
        }
        return (double)((long)sign * lValue) / gridFactor;
    }

    double getNiceHigher(double ovalue) {
        double gridFactor = 1.0;
        double mGridFactor = 1.0;
        double gridStep = this.gridStep;
        double mGridStep = this.labelStep;
        while (gridStep < 10.0) {
            gridStep *= 10.0;
            gridFactor *= 10.0;
        }
        while (mGridStep < 10.0) {
            mGridStep *= 10.0;
            mGridFactor *= 10.0;
        }
        int sign = ovalue > 0.0 ? 1 : -1;
        long lGridStep = new Double(gridStep).longValue();
        long lmGridStep = new Double(mGridStep).longValue();
        long lValue = new Double((double)sign * ovalue * gridFactor).longValue();
        long lmValue = new Double((double)sign * ovalue * mGridFactor).longValue();
        long lMod = lValue % lGridStep;
        long lmMod = lmValue % lmGridStep;
        if (ovalue < 0.0) {
            if ((double)lmMod < mGridStep * 0.5) {
                return (double)((long)sign * lmValue + lmMod) / mGridFactor;
            }
            return (double)((long)sign * lValue + lMod) / gridFactor;
        }
        if ((double)lmMod > mGridStep * 0.5) {
            return (double)((long)sign * lmValue - lmMod + lmGridStep) / mGridFactor;
        }
        return (double)((long)sign * lValue - lMod + lGridStep) / gridFactor;
    }

    private double round(double value) {
        return this.round(value, 14);
    }

    private double round(double value, int numDecs) {
        return new BigDecimal(value).setScale(numDecs, 6).doubleValue();
    }

    void exportXmlTemplate(XmlWriter xml) {
        xml.startTag("value_axis");
        xml.writeTag("grid_step", this.getGridStep());
        xml.writeTag("label_step", this.getLabelStep());
        xml.closeTag();
    }
}

