/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.jrobin.core.RrdBackend;

public class RrdFileBackend
extends RrdBackend {
    static final long LOCK_DELAY = 100L;
    private static HashSet openFiles = new HashSet();
    protected RandomAccessFile file;
    protected FileChannel channel;
    protected FileLock fileLock;

    protected RrdFileBackend(String path, boolean readOnly, int lockMode) throws IOException {
        super(path);
        this.file = new RandomAccessFile(path, readOnly ? "r" : "rw");
        this.channel = this.file.getChannel();
        if (!readOnly) {
            this.lockFile(lockMode);
            RrdFileBackend.registerWriter(path);
        }
    }

    private static synchronized void registerWriter(String path) throws IOException {
        String canonicalPath = RrdFileBackend.getCanonicalPath(path);
        if (openFiles.contains(canonicalPath)) {
            throw new IOException("File \"" + path + "\" already open for R/W access. " + "You cannot open the same file for R/W access twice");
        }
        openFiles.add(canonicalPath);
    }

    private void lockFile(int lockMode) throws IOException {
        if (lockMode == 1 || lockMode == 2) {
            do {
                this.fileLock = this.channel.tryLock();
                if (this.fileLock != null) continue;
                if (lockMode == 1) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new IOException("Access denied. File [" + this.getPath() + "] already locked");
            } while (this.fileLock == null);
        }
    }

    public void close() throws IOException {
        super.close();
        RrdFileBackend.unregisterWriter(this.getPath());
        this.unlockFile();
        this.channel.close();
        this.file.close();
    }

    private static synchronized void unregisterWriter(String path) throws IOException {
        String canonicalPath = RrdFileBackend.getCanonicalPath(path);
        openFiles.remove(canonicalPath);
    }

    private void unlockFile() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
            this.fileLock = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public static String getCanonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public String getCanonicalPath() throws IOException {
        return RrdFileBackend.getCanonicalPath(this.getPath());
    }

    protected void write(long offset, byte[] b) throws IOException {
        this.file.seek(offset);
        this.file.write(b);
    }

    protected void read(long offset, byte[] b) throws IOException {
        this.file.seek(offset);
        if (this.file.read(b) != b.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    protected void setLength(long length) throws IOException {
        this.file.setLength(length);
    }
}

