/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public final class SipProviderImpl
implements SipProvider,
SIPTransactionEventListener {
    protected SipListener sipListener;
    protected boolean isActive;
    protected SipStackImpl sipStack;
    protected ListeningPointImpl listeningPoint;
    protected EventScanner eventScanner;

    protected void stop() {
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Exiting provider");
        }
        this.listeningPoint.removeSipProvider();
        this.eventScanner.stop();
    }

    public void handleEvent(EventObject sipEvent, SIPTransaction transaction) {
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("handleEvent " + sipEvent + "currentTransaction = " + transaction + "this.sipListener = " + this.sipListener + "sipEvent.source = " + sipEvent.getSource());
            this.sipStack.logStackTrace();
        }
        EventWrapper eventWrapper = new EventWrapper();
        eventWrapper.sipEvent = sipEvent;
        eventWrapper.transaction = transaction;
        if (transaction != null) {
            transaction.setEventPending();
        }
        if (!this.sipStack.reEntrantListener) {
            this.eventScanner.addEvent(eventWrapper);
        } else {
            this.eventScanner.deliverEvent(eventWrapper);
        }
    }

    protected SipProviderImpl(EventScanner eventScanner) {
        this.eventScanner = eventScanner;
        ++this.eventScanner.refCount;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        SipProviderImpl provider;
        Iterator it;
        SipStackImpl sipStackImpl = this.sipStack;
        synchronized (sipStackImpl) {
            it = this.sipStack.getSipProviders();
            while (it.hasNext()) {
                provider = (SipProviderImpl)it.next();
                if (provider.sipListener == null || provider.sipListener == sipListener) continue;
                throw new TooManyListenersException();
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
        sipStackImpl = this.sipStack;
        synchronized (sipStackImpl) {
            it = this.sipStack.getSipProviders();
            while (it.hasNext()) {
                provider = (SipProviderImpl)it.next();
                provider.sipListener = sipListener;
            }
        }
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public CallIdHeader getNewCallId() {
        String callId = Utils.generateCallIdentifier(this.getSipStack().getIPAddress());
        CallID callid = new CallID();
        try {
            callid.setCallId(callId);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return callid;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        UnknownHostException lastException;
        SIPRequest sipRequest;
        block27: {
            HopImpl hop;
            SIPClientTransaction ct;
            if (request == null) {
                throw new NullPointerException("null request");
            }
            sipRequest = (SIPRequest)request;
            if (sipRequest.getTransaction() != null) {
                throw new TransactionUnavailableException("Transaction already assigned to request");
            }
            if (sipRequest.getTopmostVia() != null) {
                HostPort hp = sipRequest.getTopmostVia().getSentBy();
                int port = hp.getPort() == -1 ? 5060 : hp.getPort();
                Iterator it = this.sipStack.getListeningPoints();
                boolean found = false;
                while (it.hasNext()) {
                    ListeningPoint lp = (ListeningPoint)it.next();
                    if (lp.getPort() != port || !lp.getTransport().equalsIgnoreCase(sipRequest.getTopmostVia().getTransport())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TransactionUnavailableException(" No listening point for " + sipRequest.getTopmostVia().getTransport() + " at port " + port);
                }
            }
            if (request.getMethod().equalsIgnoreCase("CANCEL") && (ct = (SIPClientTransaction)this.sipStack.findCancelTransaction((SIPRequest)request, false)) != null) {
                SIPClientTransaction retval = this.sipStack.createClientTransaction(ct.getMessageChannel());
                ((SIPTransaction)retval).setOriginalRequest((SIPRequest)request);
                ((SIPTransaction)retval).addEventListener(this);
                this.sipStack.addTransaction(retval);
                retval.setDialog((SIPDialog)ct.getDialog());
                return retval;
            }
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("could not find existing transaction for " + ((SIPRequest)request).getFirstLine());
            }
            ListIterator it = this.sipStack.getRouter().getNextHops(request);
            String dialogId = sipRequest.getDialogId(false);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            lastException = null;
            if (it == null || !it.hasNext()) {
                if (dialog != null) {
                    try {
                        hop = dialog.getNextHop();
                        if (hop != null) {
                            SIPClientTransaction ct2 = (SIPClientTransaction)this.sipStack.createMessageChannel(this.listeningPoint.port, hop);
                            String branchId = Utils.generateBranchId();
                            if (sipRequest.getTopmostVia() != null) {
                                sipRequest.getTopmostVia().setBranch(branchId);
                            } else {
                                Via via = this.listeningPoint.messageProcessor.getViaHeader();
                                sipRequest.addHeader(via);
                            }
                            ct2.setOriginalRequest(sipRequest);
                            ct2.setBranch(branchId);
                            ct2.setDialog(dialog);
                            ct2.addEventListener(this);
                            return ct2;
                        }
                        break block27;
                    }
                    catch (Exception ex) {
                        throw new TransactionUnavailableException(ex.getMessage());
                    }
                }
                throw new TransactionUnavailableException("no route!");
            }
            while (it.hasNext()) {
                hop = (Hop)it.next();
                try {
                    SIPClientTransaction ct3 = (SIPClientTransaction)this.sipStack.createMessageChannel(this.listeningPoint.port, hop);
                    if (ct3 == null) continue;
                    String branchId = Utils.generateBranchId();
                    if (sipRequest.getTopmostVia() != null) {
                        sipRequest.getTopmostVia().setBranch(branchId);
                    } else {
                        Via via = this.listeningPoint.messageProcessor.getViaHeader();
                        sipRequest.addHeader(via);
                    }
                    ct3.setOriginalRequest(sipRequest);
                    ct3.setBranch(branchId);
                    if (this.sipStack.isDialogCreated(request.getMethod())) {
                        if (dialog != null) {
                            ct3.setDialog(dialog);
                        } else if (this.sipStack.dialogSupport) {
                            this.sipStack.createDialog(ct3);
                        }
                    } else {
                        ct3.setDialog(dialog);
                    }
                    ct3.addEventListener(this);
                    return ct3;
                }
                catch (UnknownHostException ex) {
                    lastException = ex;
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Error processing " + sipRequest);
        }
        if (lastException == null) {
            throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ");
        }
        throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ", (Throwable)lastException);
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        SIPServerTransaction transaction = null;
        SIPRequest sipRequest = (SIPRequest)request;
        if (this.sipStack.isDialogCreated(sipRequest.getMethod()) && this.sipStack.dialogSupport) {
            if (this.sipStack.findTransaction((SIPRequest)request, true) != null) {
                throw new TransactionAlreadyExistsException("server transaction already exists!");
            }
            if (!this.sipStack.hasResources()) {
                throw new TransactionUnavailableException("Resource Not available!");
            }
            transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (transaction == null) {
                throw new TransactionUnavailableException("Transaction not available");
            }
            if (transaction.getOriginalRequest() == null) {
                transaction.setOriginalRequest(sipRequest);
            }
            try {
                this.sipStack.addTransaction(transaction);
            }
            catch (IOException ex) {
                throw new TransactionUnavailableException("Error sending provisional response");
            }
            transaction.addEventListener(this);
            String dialogId = sipRequest.getDialogId(true);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            if (dialog == null) {
                dialog = this.sipStack.createDialog(transaction);
            } else {
                transaction.setDialog(dialog);
            }
            dialog.setStack(this.sipStack);
            dialog.addRoute(sipRequest);
            if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
                this.sipStack.putDialog(dialog);
            }
        } else {
            transaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
            if (transaction != null) {
                throw new TransactionAlreadyExistsException("Transaction exists! ");
            }
            transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (transaction == null) {
                throw new TransactionUnavailableException("Transaction not available!");
            }
            if (transaction.getOriginalRequest() == null) {
                transaction.setOriginalRequest(sipRequest);
            }
            try {
                this.sipStack.addTransaction(transaction);
            }
            catch (IOException ex) {
                throw new TransactionUnavailableException("Could not send back provisional response!");
            }
            String dialogId = sipRequest.getDialogId(true);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            if (dialog != null) {
                dialog.addTransaction(transaction);
                dialog.addRoute(sipRequest);
            }
        }
        return transaction;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
    }

    public void sendRequest(Request request) throws SipException {
        ListIterator it = this.sipStack.getRouter().getNextHops(request);
        if (it == null || !it.hasNext()) {
            throw new SipException("could not determine next hop!");
        }
        if (((SIPRequest)request).getTopmostVia() == null) {
            throw new SipException("Invalid SipRequest -- no via header!");
        }
        SIPTransaction tr = this.sipStack.findTransaction((SIPRequest)request, false);
        if (tr != null) {
            throw new SipException("Cannot send statelessly Transaction found!");
        }
        while (it.hasNext()) {
            Hop nextHop = (Hop)it.next();
            try {
                SIPRequest sipRequest = (SIPRequest)request;
                String bid = sipRequest.getTransactionId();
                Via via = sipRequest.getTopmostVia();
                via.setBranch(bid);
                SIPRequest newRequest = sipRequest;
                MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.listeningPoint.port, nextHop);
                if (messageChannel == null) continue;
                messageChannel.sendMessage(newRequest);
                return;
            }
            catch (IOException ex) {
                if (!LogWriter.needsLogging) continue;
                this.sipStack.getLogWriter().logException(ex);
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        }
        throw new SipException("could not forward request");
    }

    public void sendResponse(Response response) throws SipException {
        int port;
        SIPResponse sipResponse = (SIPResponse)response;
        Via via = sipResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!");
        }
        String transport = via.getTransport();
        String host = via.getReceived();
        if (host == null) {
            host = via.getHost();
        }
        if ((port = via.getrport()) == -1 && (port = via.getPort()) == -1) {
            port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        if (host.indexOf(":") > 0 && host.indexOf("[") < 0) {
            host = "[" + host + "]";
        }
        HopImpl hop = new HopImpl(host, port, transport);
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.listeningPoint.port, hop);
            messageChannel.sendMessage(sipResponse);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        lp.sipProviderImpl = this;
        this.listeningPoint = (ListeningPointImpl)listeningPoint;
    }

    public Dialog createDialog(Transaction transaction) throws SipException {
        if (transaction == null) {
            throw new NullPointerException("Null transaction!");
        }
        if (this.sipStack.dialogSupport) {
            throw new SipException("Stack Configuration Error - AUTOMATIC_DIALOG_SUPPORT is on");
        }
        if (!this.sipStack.isDialogCreated(transaction.getRequest().getMethod())) {
            throw new SipException("Dialog cannot be created for this method " + transaction.getRequest().getMethod());
        }
        if (transaction.getDialog() != null) {
            throw new SipException("Dialog is already set! ");
        }
        SIPDialog dialog = null;
        SIPTransaction sipTransaction = (SIPTransaction)transaction;
        SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
        if (transaction instanceof ServerTransaction) {
            String dialogId = sipRequest.getDialogId(true);
            dialog = this.sipStack.getDialog(dialogId);
            if (dialog == null) {
                dialog = this.sipStack.createDialog((SIPTransaction)transaction);
                dialog.addTransaction(sipTransaction);
                dialog.addRoute(sipRequest);
            } else {
                sipTransaction.setDialog(dialog);
            }
        } else {
            if (sipTransaction.getState() != null) {
                throw new SipException("Cannot create dialog after state is assigned");
            }
            dialog = this.sipStack.createDialog(sipTransaction);
            sipTransaction.setDialog(dialog);
        }
        return dialog;
    }

    protected void setSipStack(SipStackImpl sipStack) {
        this.sipStack = sipStack;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("TransportError occured on " + transaction);
            }
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent((EventObject)ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 1) {
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent((EventObject)ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 3) {
            if (this.sipStack.isRetransmissionFilterActive()) {
                InternalErrorHandler.handleException("Unexpected event !");
            }
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.RETRANSMIT;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent((EventObject)ev, (SIPTransaction)errorObject);
        }
    }
}

