/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTags;

public class DEROutputStream
extends FilterOutputStream
implements DERTags {
    public DEROutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void writeLength(int n) throws IOException {
        if (n > 127) {
            int n2 = 1;
            int n3 = n;
            while ((n3 >>>= 8) != 0) {
                ++n2;
            }
            this.write((byte)(n2 | 0x80));
            for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
                this.write((byte)(n >> i));
            }
        } else {
            this.write((byte)n);
        }
    }

    void writeEncoded(int n, byte[] byArray) throws IOException {
        this.write(n);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.write(5);
        this.write(0);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof DERObject) {
            ((DERObject)object).encode(this);
        } else if (object instanceof DEREncodable) {
            ((DEREncodable)object).getDERObject().encode(this);
        } else {
            throw new IOException("object not DEREncodable");
        }
    }
}

