/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Thread keepAliveThread;
    private Writer writer;
    private XMPPConnection connection;
    private final BlockingQueue<Packet> queue;
    private boolean done;
    private long lastActive = System.currentTimeMillis();

    protected PacketWriter(XMPPConnection connection) {
        this.queue = new ArrayBlockingQueue<Packet>(500, true);
        this.connection = connection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.connection.firePacketInterceptors(packet);
            try {
                this.queue.put(packet);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return;
            }
            BlockingQueue<Packet> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.connection.firePacketSendingListeners(packet);
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void startKeepAliveProcess() {
        int keepAliveInterval = SmackConfiguration.getKeepAliveInterval();
        if (keepAliveInterval > 0) {
            KeepAliveTask task = new KeepAliveTask(keepAliveInterval);
            this.keepAliveThread = new Thread(task);
            task.setThread(this.keepAliveThread);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.setName("Smack Keep Alive (" + this.connection.connectionCounterValue + ")");
            this.keepAliveThread.start();
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
    }

    void cleanup() {
        this.connection.interceptors.clear();
        this.connection.sendListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackets(Thread thisThread) {
        block24: {
            try {
                Object packet;
                this.openStream();
                while (!this.done && this.writerThread == thisThread) {
                    packet = this.nextPacket();
                    if (packet == null) continue;
                    Writer writer = this.writer;
                    synchronized (writer) {
                        this.writer.write(((Packet)packet).toXML());
                        this.writer.flush();
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                try {
                    packet = this.writer;
                    synchronized (packet) {
                        while (!this.queue.isEmpty()) {
                            Packet packet2 = (Packet)this.queue.remove();
                            this.writer.write(packet2.toXML());
                        }
                        this.writer.flush();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.queue.clear();
                try {
                    this.writer.write("</stream:stream>");
                    this.writer.flush();
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (IOException ioe) {
                if (this.done) break block24;
                this.done = true;
                this.connection.packetReader.notifyConnectionError(ioe);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stream = new StringBuilder();
        stream.append("<stream:stream");
        stream.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stream.append(" xmlns=\"jabber:client\"");
        stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stream.append(" version=\"1.0\">");
        this.writer.write(stream.toString());
        this.writer.flush();
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;
        private Thread thread;

        public KeepAliveTask(int delay) {
            this.delay = delay;
        }

        protected void setThread(Thread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            while (!PacketWriter.this.done && PacketWriter.this.keepAliveThread == this.thread) {
                Writer ie = PacketWriter.this.writer;
                synchronized (ie) {
                    if (System.currentTimeMillis() - PacketWriter.this.lastActive >= (long)this.delay) {
                        try {
                            PacketWriter.this.writer.write(" ");
                            PacketWriter.this.writer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

