/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jqql.Util;
import net.sf.jqql.beans.Card;
import net.sf.jqql.beans.CardStub;
import net.sf.jqql.beans.ClusterInfo;
import net.sf.jqql.beans.Member;
import net.sf.jqql.beans.QQFriend;
import net.sf.jqql.beans.QQOrganization;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.beans.SimpleClusterInfo;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class ClusterCommandReplyPacket
extends _08BasicInPacket {
    public byte subCommand;
    public byte replyCode;
    public int clusterId;
    public int externalId;
    public byte type;
    public int parentClusterId;
    public int versionId;
    public int memberQQ;
    public String errorMessage;
    public ClusterInfo info;
    public List<Member> members;
    public List<QQFriend> memberInfos;
    public List<Integer> onlineMembers;
    public List<SimpleClusterInfo> subClusters;
    public byte subClusterOpByte;
    public byte joinReply;
    public byte searchType;
    public List<ClusterInfo> clusters;
    public int organizationVersionId;
    public int organizationCount;
    public List<QQOrganization> organizations;
    public int memberOrganziationVersionId;
    public List<CardStub> cardStubs;
    public int cardVersionId;
    public int nextStart;
    public Card card;
    public byte role;

    public ClusterCommandReplyPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Cluster Command Reply";
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.subCommand = byteBuffer.get();
        this.replyCode = byteBuffer.get();
        switch (this.subCommand) {
            case 26: {
                this.parseSendIMReply(byteBuffer);
                break;
            }
            case 53: {
                this.parseSendTempClusterIMReply(byteBuffer);
                break;
            }
            case 1: {
                this.parseCreateReply(byteBuffer);
                break;
            }
            case 48: {
                this.parseCreateTempCluster(byteBuffer);
                break;
            }
            case 5: {
                this.parseActivateReply(byteBuffer);
                break;
            }
            case 2: {
                this.parseModifyMemberReply(byteBuffer);
                break;
            }
            case 4: {
                this.parseGetInfoReply(byteBuffer);
                break;
            }
            case 9: {
                this.parseExitReply(byteBuffer);
                break;
            }
            case 12: {
                this.parseGetMemberInfoReply(byteBuffer);
                break;
            }
            case 11: {
                this.parseGetOnlineMemberReply(byteBuffer);
                break;
            }
            case 7: {
                this.parseJoinReply(byteBuffer);
                break;
            }
            case 8: {
                this.parseJoinAuthReply(byteBuffer);
                break;
            }
            case 3: {
                this.parseModifyInfoReply(byteBuffer);
                break;
            }
            case 6: {
                this.parseSearchReply(byteBuffer);
                break;
            }
            case 51: {
                this.parseGetTempClusterInfoReply(byteBuffer);
                break;
            }
            case 50: {
                this.parseExitTempClusterReply(byteBuffer);
                break;
            }
            case 55: {
                this.parseActivateTempCluster(byteBuffer);
                break;
            }
            case 54: {
                this.parseSubClusterOp(byteBuffer);
                break;
            }
            case 18: {
                this.parseUpdateOrganization(byteBuffer);
                break;
            }
            case 17: {
                this.parseCommitOrganization(byteBuffer);
                break;
            }
            case 19: {
                this.parseCommitMemberOrganization(byteBuffer);
                break;
            }
            case 52: {
                this.parseModifyTempClusterInfo(byteBuffer);
                break;
            }
            case 14: {
                this.parseModifyCard(byteBuffer);
                break;
            }
            case 15: {
                this.parseGetCardBatch(byteBuffer);
                break;
            }
            case 16: {
                this.parseGetCard(byteBuffer);
                break;
            }
            case 27: {
                this.parseSetRole(byteBuffer);
                break;
            }
            case 28: {
                this.parseTransferRole(byteBuffer);
                break;
            }
            case 29: {
                this.parseDismissCluster(byteBuffer);
            }
        }
        if (this.replyCode != 0) {
            switch (this.subCommand) {
                case 28: {
                    this.clusterId = byteBuffer.getInt();
                    this.memberQQ = byteBuffer.getInt();
                    this.errorMessage = Util.getString(byteBuffer);
                    break;
                }
                case 27: {
                    this.clusterId = byteBuffer.getInt();
                    this.errorMessage = Util.getString(byteBuffer);
                    break;
                }
                default: {
                    this.errorMessage = Util.getString(byteBuffer);
                }
            }
        }
    }

    private void parseDismissCluster(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseTransferRole(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.memberQQ = byteBuffer.getInt();
            this.versionId = byteBuffer.getInt();
        }
    }

    private void parseSetRole(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.versionId = byteBuffer.getInt();
            this.memberQQ = byteBuffer.getInt();
            this.role = byteBuffer.get();
        }
    }

    private void parseGetCard(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.memberQQ = byteBuffer.getInt();
            this.card = new Card();
            this.card.readBean(byteBuffer);
        }
    }

    private void parseGetCardBatch(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.cardVersionId = byteBuffer.getInt();
            this.cardStubs = new ArrayList<CardStub>();
            this.nextStart = byteBuffer.getInt();
            while (byteBuffer.hasRemaining()) {
                CardStub cardStub = new CardStub();
                cardStub.readBean(byteBuffer);
                this.cardStubs.add(cardStub);
            }
        }
    }

    private void parseModifyCard(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseModifyTempClusterInfo(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.type = byteBuffer.get();
            this.parentClusterId = byteBuffer.getInt();
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseCommitMemberOrganization(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.memberOrganziationVersionId = byteBuffer.getInt();
        }
    }

    private void parseCommitOrganization(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.organizationVersionId = byteBuffer.getInt();
            this.organizationCount = byteBuffer.getChar();
        }
    }

    private void parseUpdateOrganization(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.organizations = new ArrayList<QQOrganization>();
            this.clusterId = byteBuffer.getInt();
            byteBuffer.get();
            this.organizationVersionId = byteBuffer.getInt();
            if (this.organizationVersionId != 0) {
                this.organizationCount = byteBuffer.get() & 0xFF;
                while (byteBuffer.hasRemaining()) {
                    QQOrganization qQOrganization = new QQOrganization();
                    qQOrganization.readBean(byteBuffer);
                    this.organizations.add(qQOrganization);
                }
            }
        }
    }

    private void parseSubClusterOp(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.subClusterOpByte = byteBuffer.get();
            this.clusterId = byteBuffer.getInt();
            this.externalId = byteBuffer.getInt();
            this.subClusters = new ArrayList<SimpleClusterInfo>();
            while (byteBuffer.hasRemaining()) {
                SimpleClusterInfo simpleClusterInfo = new SimpleClusterInfo();
                simpleClusterInfo.readBean(byteBuffer);
                this.subClusters.add(simpleClusterInfo);
            }
        }
    }

    private void parseCreateTempCluster(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.type = byteBuffer.get();
            this.parentClusterId = byteBuffer.getInt();
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseExitTempClusterReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.type = byteBuffer.get();
            this.parentClusterId = byteBuffer.getInt();
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseSendTempClusterIMReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.type = byteBuffer.get();
            this.parentClusterId = byteBuffer.getInt();
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseModifyMemberReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseSendIMReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseSearchReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.searchType = byteBuffer.get();
            this.clusters = new ArrayList<ClusterInfo>();
            while (byteBuffer.hasRemaining()) {
                ClusterInfo clusterInfo = new ClusterInfo();
                clusterInfo.readClusterInfoFromSearchReply(byteBuffer);
                this.clusters.add(clusterInfo);
            }
        }
    }

    private void parseModifyInfoReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseJoinAuthReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseJoinReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.joinReply = byteBuffer.get();
        }
    }

    private void parseGetOnlineMemberReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            byteBuffer.get();
            this.onlineMembers = new ArrayList<Integer>();
            while (byteBuffer.hasRemaining()) {
                this.onlineMembers.add(byteBuffer.getInt());
            }
        }
    }

    private void parseActivateTempCluster(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.type = byteBuffer.get();
            this.parentClusterId = byteBuffer.getInt();
            this.clusterId = byteBuffer.getInt();
            this.members = new ArrayList<Member>();
            while (byteBuffer.hasRemaining()) {
                Member member = new Member();
                member.qq = byteBuffer.getInt();
                this.members.add(member);
            }
        }
    }

    private void parseGetMemberInfoReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.memberInfos = new ArrayList<QQFriend>();
            while (byteBuffer.hasRemaining()) {
                QQFriend qQFriend = new QQFriend();
                qQFriend.readBean(byteBuffer);
                this.memberInfos.add(qQFriend);
            }
        }
    }

    private void parseExitReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseGetInfoReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.info = new ClusterInfo();
            this.info.readClusterInfo(byteBuffer);
            this.clusterId = this.info.clusterId;
            this.externalId = this.info.externalId;
            this.members = new ArrayList<Member>();
            while (byteBuffer.hasRemaining()) {
                Member member = new Member();
                member.readBean(byteBuffer);
                this.members.add(member);
            }
        }
    }

    private void parseGetTempClusterInfoReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.info = new ClusterInfo();
            this.info.readTempClusterInfo(byteBuffer);
            this.type = this.info.type;
            this.clusterId = this.info.clusterId;
            this.parentClusterId = this.info.externalId;
            this.members = new ArrayList<Member>();
            while (byteBuffer.hasRemaining()) {
                Member member = new Member();
                member.readTempBean(byteBuffer);
                this.members.add(member);
            }
        }
    }

    private void parseActivateReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
        }
    }

    private void parseCreateReply(ByteBuffer byteBuffer) {
        if (this.replyCode == 0) {
            this.clusterId = byteBuffer.getInt();
            this.externalId = byteBuffer.getInt();
        }
    }
}

