/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
implements Message {
    private final String message;
    private final boolean autoResponse;
    private final Set<Attachment> attachments;

    public DirectMessage(String message, boolean autoResponse) {
        this(message, autoResponse, Collections.EMPTY_SET);
    }

    public DirectMessage(String message, boolean autoResponse, Attachment ... attachments) {
        this(message, autoResponse, new LinkedHashSet<Attachment>(Arrays.asList(attachments)));
    }

    public DirectMessage(String message, boolean autoResponse, Set<Attachment> attachments) {
        this.message = message;
        this.autoResponse = autoResponse;
        this.attachments = DefensiveTools.getUnmodifiableSetCopy(attachments);
    }

    @Override
    public String getMessageBody() {
        return this.message;
    }

    @Override
    public boolean isAutoResponse() {
        return this.autoResponse;
    }

    public Set<Attachment> getAttachments() {
        return this.attachments;
    }
}

