/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class SimpleNamedItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    private static final int PARENTID_DEFAULT = 0;
    private final String sn;
    private final int id;

    protected SimpleNamedItem(SsiItem ssiItem) {
        this(ssiItem.getName(), ssiItem.getId(), TlvTools.readChain(ssiItem.getData()));
    }

    protected SimpleNamedItem(SimpleNamedItem simpleNamedItem) {
        this(simpleNamedItem.sn, simpleNamedItem.id, simpleNamedItem.copyExtraTlvs());
    }

    protected SimpleNamedItem(String string, int n) {
        this(string, n, null);
    }

    protected SimpleNamedItem(String string, int n, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "id", 0);
        this.sn = string;
        this.id = n;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getId() {
        return this.id;
    }

    protected abstract int getItemType();

    public SsiItem toSsiItem() {
        return this.generateItem(this.sn, 0, this.id, this.getItemType(), null);
    }

    public String toString() {
        return MiscTools.getClassName(this) + " for " + this.sn + " (id=0x" + Integer.toHexString(this.id) + ")";
    }
}

