/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.buddy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.buddy.BuddyCommand;

public class BuddyOfflineCmd
extends BuddyCommand {
    private final String sn;

    protected BuddyOfflineCmd(SnacPacket packet) {
        super(12);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        StringBlock snInfo = OscarTools.readScreenname(snacData);
        this.sn = snInfo == null ? null : snInfo.getString();
    }

    public BuddyOfflineCmd(String sn) {
        super(12);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        this.sn = sn;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
    }

    public String toString() {
        return "BuddyOfflineCmd for " + this.sn;
    }
}

