/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hn.sleek.jmml.Contact;
import org.hn.sleek.jmml.ContactChangeEvent;
import org.hn.sleek.jmml.ContactList;
import org.hn.sleek.jmml.DispatchServerConnector;
import org.hn.sleek.jmml.IncomingMessageEvent;
import org.hn.sleek.jmml.MSNException;
import org.hn.sleek.jmml.MessengerClientAdapter;
import org.hn.sleek.jmml.MessengerClientListener;
import org.hn.sleek.jmml.NotificationServerConnector;
import org.hn.sleek.jmml.Profile;

public class MessengerServerManager {
    static MessengerServerManager instance;
    Vector clientListeners = new Vector();
    NotificationServerConnector notificationServer;

    private MessengerServerManager() {
        if (Security.getProvider("SunJSSE") == null) {
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String strAuthType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String strAuthType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            System.err.println("MessengerServerManger.MessengerServerManger() - " + e);
        }
    }

    public static MessengerServerManager getInstance() {
        if (instance == null) {
            instance = new MessengerServerManager();
        }
        return instance;
    }

    public void signIn(String userName, String password, String strStatus) throws MSNException {
        this.signIn(userName, password, strStatus, true);
        if (!this.isConnected()) {
            throw new MSNException(1);
        }
    }

    public void signIn(String userName, String password, String strStatus, boolean blocking) throws MSNException {
        DispatchServerConnector ds = new DispatchServerConnector();
        ArrayList serverInfo = ds.getNSServer(userName);
        if (serverInfo == null) {
            System.err.println("MessengerServerManager.signIn() - No Notification server assigned. Unable to login");
            this.fireLoginError();
            throw new MSNException(1);
        }
        this.notificationServer = new NotificationServerConnector((String)serverInfo.get(0), (Integer)serverInfo.get(1));
        this.notificationServer.signIn(userName, password, strStatus, blocking);
    }

    public void signOut() throws MSNException {
        this.notificationServer.signOut();
    }

    public boolean isConnected() {
        if (this.notificationServer != null) {
            return this.notificationServer.isConnected();
        }
        return false;
    }

    public String getUserName() {
        return this.notificationServer.getUserName();
    }

    public void setStatus(String strNewStatus) throws MSNException {
        this.notificationServer.setStatus(strNewStatus);
    }

    public String getStatus() {
        return this.notificationServer.getStatus();
    }

    public void setPrivacyMode(boolean bAllowAll) throws MSNException {
        this.notificationServer.setPrivacyMode(bAllowAll);
    }

    public boolean getPrivacyMode() throws MSNException {
        return this.notificationServer.getPrivacyMode();
    }

    public void setReverseListBehaviour(boolean bAutomaticAddRLToAL) throws MSNException {
        this.notificationServer.setReverseListBehaviour(bAutomaticAddRLToAL);
    }

    public boolean getReverseListBehaviour() throws MSNException {
        return this.notificationServer.getReverseListBehaviour();
    }

    public void allowContact(String strUserName) throws MSNException {
        Contact contact = this.getContactList().getContact(strUserName);
        if (contact != null) {
            if (contact.isBlocked()) {
                contact = new Contact(strUserName, 1);
                this.removeFromContactList(contact, -3);
                return;
            }
            if (contact.isAllowed()) {
                throw new MSNException(8);
            }
        }
        contact = new Contact(strUserName, 0);
        this.addToContactList(contact);
    }

    public void blockContact(String strUserName) throws MSNException {
        Contact contact = this.getContactList().getContact(strUserName);
        if (contact != null) {
            if (contact.isAllowed()) {
                contact = new Contact(strUserName, 0);
                this.removeFromContactList(contact, -2);
                return;
            }
            if (!contact.isBlocked()) {
                throw new MSNException(8);
            }
        }
        contact = new Contact(strUserName, 1);
        this.addToContactList(contact);
    }

    public void addToContactList(Contact contact) throws MSNException {
        this.addToContactList(contact, -1);
    }

    public void addToContactList(Contact contact, int nGroupId) throws MSNException {
        this.notificationServer.addToContactList(contact, nGroupId);
    }

    public void removeFromContactList(Contact contact) throws MSNException {
        this.removeFromContactList(contact, -1);
    }

    public void removeFromContactList(Contact contact, int nGroupId) throws MSNException {
        this.notificationServer.removeFromContactList(contact, nGroupId);
    }

    public ContactList getContactList() {
        return this.notificationServer.getContactList();
    }

    public void synchronizeContactList() throws MSNException {
        this.notificationServer.synchronizeContactList();
    }

    public Hashtable getGroups() {
        return this.notificationServer.getGroups();
    }

    void addGroup(String strGroupName) throws MSNException {
        this.notificationServer.addGroup(strGroupName);
    }

    void removeGroup(int nGroupId) throws MSNException {
        this.notificationServer.removeGroup(nGroupId);
    }

    public void renameGroup(int nGroupId, String strNewGroupName) throws MSNException {
        this.notificationServer.renameGroup(nGroupId, strNewGroupName);
    }

    void sendEmailInvitation(String strUserEmail) throws MSNException {
        this.notificationServer.sendEmailInvitation(strUserEmail);
    }

    public void sendMessage(String userName, String message) throws MSNException {
        this.notificationServer.sendMessage(userName, message);
    }

    public void setFriendlyName(String strFriendlyName) throws MSNException {
        this.notificationServer.setFriendlyName(strFriendlyName);
    }

    public void setPhoneNumber(String strPhoneNumber, int nPhoneType) throws MSNException {
        this.notificationServer.setPhoneNumber(strPhoneNumber, nPhoneType);
    }

    public String getPhoneNumber(int nPhoneType) throws MSNException {
        return this.notificationServer.getPhoneNumber(nPhoneType);
    }

    public void setMobileAuthorization(boolean bAuthorize) throws MSNException {
        this.notificationServer.setMobileAuthorization(bAuthorize);
    }

    public boolean getMobileAuthorization() throws MSNException {
        return this.notificationServer.getMobileAuthorization();
    }

    public void setMobileDeviceEnabled(boolean bEnableMobileDevice) throws MSNException {
        this.notificationServer.setMobileDeviceEnabled(bEnableMobileDevice);
    }

    public boolean getMobileDeviceEnabled() throws MSNException {
        return this.notificationServer.getMobileDeviceEnabled();
    }

    public Profile getProfile() {
        return this.notificationServer.getProfile();
    }

    public synchronized void addMessengerClientListener(MessengerClientListener newListener) {
        this.clientListeners.add(newListener);
    }

    public synchronized void removeMessengerClientListener(MessengerClientListener listener) {
        this.clientListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIncomingMessageEvent(String userName, String friendlyName, String message) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        IncomingMessageEvent event = new IncomingMessageEvent(userName, friendlyName, message);
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.incomingMessage(event);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireIncomingMessageEvent() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactChangeEvent(String userName, int property, Object newValue, String sourceCommand) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ContactChangeEvent event = new ContactChangeEvent(userName, property, newValue, sourceCommand);
        ListIterator listeners = cloneListener.listIterator();
        System.err.println("MessengerServerManager.fireContactChangeEvent() - " + event.toString());
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.contactPropertyChanged(event);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireContactChangeEvent() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerDisconnected() {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.serverDisconnected();
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireServerDisconnected() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLoginError() {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.loginError();
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireLoginError() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLoginAccepted() {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.loginAccepted();
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireLoginAccepted() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGroupReceived(int nGroupId, String strGroupName) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.groupReceived(nGroupId, strGroupName);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireGroupReceived() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGroupAdded(int nGroupId, String strGroupName) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.groupAdded(nGroupId, strGroupName);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireGroupAdded() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGroupRemoved(int nGroupId, String strGroupName) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.groupRemoved(nGroupId, strGroupName);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireGroupRemoved() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGroupRenamed(int nGroupId, String strNewGroupName) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.groupRenamed(nGroupId, strNewGroupName);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireGroupRenamed() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactReceived(Contact contact) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.contactReceived(contact);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireContactReceived() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactAdded(Contact contact) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.contactAdded(contact);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireContactAdded() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactRemoved(Contact contact) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.contactRemoved(contact);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireContactRemoved() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUserBeginTyping(Contact contact) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.userBeginTyping(contact);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireUserBeginTyping() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUserEndTyping(Contact contact) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.userEndTyping(contact);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.fireUserEndTyping() - " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireErrorReceived(int nErrorCode) {
        Vector cloneListener;
        MessengerServerManager messengerServerManager = this;
        synchronized (messengerServerManager) {
            cloneListener = (Vector)this.clientListeners.clone();
        }
        ListIterator listeners = cloneListener.listIterator();
        while (listeners.hasNext()) {
            try {
                MessengerClientListener listener = (MessengerClientListener)listeners.next();
                listener.errorReceived(nErrorCode);
            }
            catch (Exception e) {
                System.err.println("MessengerServerManager.errorReceived() - " + e);
            }
        }
    }

    public static void main(String[] args) {
        final MessengerServerManager msn = MessengerServerManager.getInstance();
        String[] cleverResponses = new String[]{"InfoBot forever!", "Tony kicks ass!", "MSN Messenger is cool!", "What's up?", "Halo is cool, but Quake is better!", "I beat Darren in Halo", "My name is MobileJane."};
        msn.addMessengerClientListener(new MessengerClientAdapter(){

            public void incomingMessage(IncomingMessageEvent e) {
                System.out.println(e.getMessage());
                int clever = e.getMessage().length() % 7;
                String cleverResponse = "Clever response...";
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("/usr/games/fortune").getInputStream()));
                    StringBuffer sb = new StringBuffer();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        line = br.readLine();
                    }
                    cleverResponse = sb.toString();
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
                try {
                    msn.sendMessage(e.getUserName(), cleverResponse);
                }
                catch (MSNException ex) {
                    System.err.println("MessengerServerManager.main() - " + ex);
                }
            }

            public void contactPropertyChanged(ContactChangeEvent event) {
                System.out.println("Contact Change: " + event);
            }

            public void serverDisconnected() {
                System.out.println("MessengerServerManager.main.serverDisconnected() - Server disconnected");
            }

            public void loginError() {
                System.out.println("MessengerServerManager.main.loginError() - Login Error");
            }
        });
        try {
            msn.signIn(args[0], args[1], "NLN");
        }
        catch (MSNException e) {
            System.out.println("main() - " + e);
        }
        if (msn.isConnected()) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        msn.synchronizeContactList();
                    }
                    catch (MSNException ex) {
                        System.err.println("MessengerServerManager.main() - " + ex);
                    }
                }
            };
            t.start();
        }
    }
}

