/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends BufferedInputStream
implements SharedInputStream {
    private static int defaultBufferSize = 2048;
    protected RandomAccessFile in;
    protected int bufsize;
    protected long bufpos;
    protected long start = 0L;
    protected long datalen;
    private boolean master = true;
    private SharedFile sf;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public SharedFileInputStream(File file) throws IOException {
        this(file, defaultBufferSize);
    }

    public SharedFileInputStream(String string) throws IOException {
        this(string, defaultBufferSize);
    }

    public SharedFileInputStream(File file, int n) throws IOException {
        super(null);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.init(new SharedFile(file), n);
    }

    public SharedFileInputStream(String string, int n) throws IOException {
        super(null);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.init(new SharedFile(string), n);
    }

    private void init(SharedFile sharedFile, int n) throws IOException {
        this.sf = sharedFile;
        this.in = sharedFile.open();
        this.start = 0L;
        this.datalen = this.in.length();
        this.bufsize = n;
        this.buf = new byte[n];
    }

    private SharedFileInputStream(SharedFile sharedFile, long l, long l2, int n) {
        super(null);
        this.master = false;
        this.sf = sharedFile;
        this.in = sharedFile.open();
        this.start = l;
        this.bufpos = l;
        this.datalen = l2;
        this.bufsize = n;
        this.buf = new byte[n];
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markpos < 0) {
            this.pos = 0;
            this.bufpos += (long)this.count;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n2 = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n2);
                this.pos = n2;
                this.bufpos += (long)this.markpos;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
                this.bufpos += (long)this.count;
            } else {
                n2 = this.pos * 2;
                if (n2 > this.marklimit) {
                    n2 = this.marklimit;
                }
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        this.in.seek(this.bufpos + (long)this.pos);
        n2 = this.buf.length - this.pos;
        if (this.bufpos - this.start + (long)this.pos + (long)n2 > this.datalen) {
            n2 = (int)(this.datalen - (this.bufpos - this.start + (long)this.pos));
        }
        if ((n = this.in.read(this.buf, this.pos, n2)) > 0) {
            this.count = n + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        this.ensureOpen();
        if ((var2_2 | var3_3 | var2_2 + var3_3 | var1_1.length - (var2_2 + var3_3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 == 0) {
            return 0;
        }
        var4_4 = this.read1(var1_1, var2_2, var3_3);
        if (var4_4 > 0) ** GOTO lbl11
        return var4_4;
        while ((var5_5 = this.read1(var1_1, var2_2 + var4_4, var3_3 - var4_4)) > 0) {
            var4_4 += var5_5;
lbl11:
            // 2 sources

            if (var4_4 < var3_3) continue;
        }
        return var4_4;
    }

    public synchronized long skip(long l) throws IOException {
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            this.fill();
            l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.pos = (int)((long)this.pos + l3);
        return l3;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in_available();
    }

    private int in_available() throws IOException {
        return (int)(this.start + this.datalen - (this.bufpos + (long)this.count));
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            if (this.master) {
                this.sf.forceClose();
            } else {
                this.sf.close();
            }
            Object var2_1 = null;
            this.sf = null;
            this.in = null;
            this.buf = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.sf = null;
            this.in = null;
            this.buf = null;
            throw throwable;
        }
    }

    public long getPosition() {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        return this.bufpos + (long)this.pos - this.start;
    }

    public InputStream newStream(long l, long l2) {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("start < 0");
        }
        if (l2 == -1L) {
            l2 = this.datalen;
        }
        return new SharedFileInputStream(this.sf, this.start + (long)((int)l), (int)(l2 - l), this.bufsize);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    class SharedFile {
        private int cnt;
        private RandomAccessFile in;

        SharedFile(String string) throws IOException {
            this.in = new RandomAccessFile(string, "r");
        }

        SharedFile(File file) throws IOException {
            this.in = new RandomAccessFile(file, "r");
        }

        public RandomAccessFile open() {
            ++this.cnt;
            return this.in;
        }

        public synchronized void close() throws IOException {
            if (this.cnt > 0 && --this.cnt <= 0) {
                this.in.close();
            }
        }

        public synchronized void forceClose() throws IOException {
            if (this.cnt > 0) {
                this.cnt = 0;
                this.in.close();
            } else {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.in.close();
        }
    }
}

