/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.AbstractTokenRequest;
import pl.mn.communicator.packet.http.HttpResponse;

public class RegisterGGAccountRequest
extends AbstractTokenRequest {
    private String m_email = null;
    private String m_password = null;

    public RegisterGGAccountRequest(IGGConfiguration configuration, String email, String password, String tokenID, String tokenVal) throws IOException {
        super(configuration, tokenID, tokenVal);
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        this.m_email = email;
        this.m_password = password;
    }

    public HttpResponse getResponse() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_huc.getInputStream(), "windows-1250"));
        String line = reader.readLine();
        return new RegisterGGAccountResponse(line);
    }

    protected String getURL() {
        return this.m_ggconfiguration.getRegistrationURL();
    }

    protected String getRequestBody() throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("pwd=");
        buffer.append(URLEncoder.encode(this.m_password, "windows-1250"));
        buffer.append('&');
        buffer.append("email=");
        buffer.append(URLEncoder.encode(this.m_email, "windows-1250"));
        buffer.append('&');
        buffer.append("tokenid=");
        buffer.append(URLEncoder.encode(this.getTokenID(), "windows-1250"));
        buffer.append('&');
        buffer.append("tokenval=");
        buffer.append(URLEncoder.encode(this.getTokenVal(), "windows-1250"));
        buffer.append('&');
        buffer.append("code=");
        buffer.append(this.getHashCode(this.m_email, this.m_password));
        return buffer.toString();
    }

    protected boolean wannaWrite() {
        return true;
    }

    public static class RegisterGGAccountResponse
    extends HttpResponse {
        private String m_responseString = null;

        public RegisterGGAccountResponse(String responseString) {
            this.m_responseString = responseString;
        }

        public boolean isOKResponse() {
            return this.m_responseString.startsWith("reg_success");
        }

        public String getResponseMessage() {
            return this.m_responseString;
        }

        public int getNewUin() {
            if (this.isOKResponse()) {
                StringTokenizer tokenizer = new StringTokenizer(this.m_responseString, ":");
                String token1 = tokenizer.nextToken();
                String token2 = tokenizer.nextToken();
                return Integer.parseInt(token2);
            }
            return -1;
        }
    }
}

