/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Random;

public class Utils {
    private static MessageDigest digester;
    private static Random rand;
    private static long counter;
    private static int callIDCounter;
    private static final char[] toHex;

    public static String toHexString(byte[] byArray) {
        int n = 0;
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[n++] = toHex[byArray[i] >> 4 & 0xF];
            cArray[n++] = toHex[byArray[i] & 0xF];
        }
        return new String(cArray);
    }

    public static String getQuotedString(String string) {
        return '\"' + string + '\"';
    }

    protected static String reduceString(String string) {
        String string2 = string.toLowerCase();
        int n = string2.length();
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            if (string2.charAt(i) == ' ' || string2.charAt(i) == '\t') continue;
            string3 = string3 + string2.charAt(i);
        }
        return string3;
    }

    public static synchronized String generateCallIdentifier(String string) {
        String string2 = new Long(System.currentTimeMillis() + (long)callIDCounter++ + rand.nextLong()).toString();
        byte[] byArray = digester.digest(string2.getBytes());
        String string3 = Utils.toHexString(byArray);
        return string3 + "@" + string;
    }

    public static synchronized String generateTag() {
        return Integer.toHexString(rand.nextInt());
    }

    public static synchronized String generateBranchId() {
        long l = rand.nextLong() + counter++ + System.currentTimeMillis();
        byte[] byArray = digester.digest(Long.toString(l).getBytes());
        return "z9hG4bK" + Utils.toHexString(byArray);
    }

    public static void main(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < 100000; ++i) {
            String string = Utils.generateBranchId();
            if (hashSet.contains(string)) {
                throw new RuntimeException("Duplicate Branch ID");
            }
            hashSet.add(string);
        }
        System.out.println("Done!!");
    }

    static {
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not intialize Digester ", exception);
        }
        rand = new Random();
        counter = 0L;
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

