/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

public enum MediaType {
    AUDIO("audio"),
    VIDEO("video"),
    DATA("data");

    private final String mediaTypeName;

    private MediaType(String mediaTypeName) {
        this.mediaTypeName = mediaTypeName;
    }

    public String toString() {
        return this.mediaTypeName;
    }

    public static MediaType parseString(String mediaTypeName) throws IllegalArgumentException {
        if (AUDIO.toString().equals(mediaTypeName)) {
            return AUDIO;
        }
        if (VIDEO.toString().equals(mediaTypeName)) {
            return VIDEO;
        }
        if (DATA.toString().equals(mediaTypeName)) {
            return DATA;
        }
        throw new IllegalArgumentException(mediaTypeName + " is not a currently supported MediaType");
    }
}

