/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.DTLSClientProtocol;
import org.bouncycastle.crypto.tls.DTLSProtocol;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.TlsServerContext;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DatagramTransportImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.neomedia.transform.dtls.TlsClientImpl;
import org.jitsi.impl.neomedia.transform.dtls.TlsServerImpl;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;

public class DtlsPacketTransformer
extends SinglePacketTransformer {
    private static final int CONNECT_TRIES = 3;
    private static final long CONNECT_RETRY_INTERVAL = 500L;
    static final int DTLS_RECORD_HEADER_LENGTH = 13;
    private static final int DTLS_TRANSPORT_RECEIVE_WAITMILLIS = -1;
    private static final Logger logger = Logger.getLogger(DtlsPacketTransformer.class);
    private final int componentID;
    private Thread connectThread;
    private AbstractRTPConnector connector;
    private DatagramTransportImpl datagramTransport;
    private DTLSTransport dtlsTransport;
    private MediaType mediaType;
    private SinglePacketTransformer srtpTransformer;
    private DtlsControl.Setup setup;
    private final DtlsTransformEngine transformEngine;

    public static boolean isDtlsRecord(byte[] buf, int off, int len) {
        boolean b = false;
        if (len >= 13) {
            short type = TlsUtils.readUint8((byte[])buf, (int)off);
            switch (type) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    int length;
                    int major = buf[off + 1] & 0xFF;
                    int minor = buf[off + 2] & 0xFF;
                    ProtocolVersion version = null;
                    if (major == ProtocolVersion.DTLSv10.getMajorVersion() && minor == ProtocolVersion.DTLSv10.getMinorVersion()) {
                        version = ProtocolVersion.DTLSv10;
                    }
                    if (version == null && major == ProtocolVersion.DTLSv12.getMajorVersion() && minor == ProtocolVersion.DTLSv12.getMinorVersion()) {
                        version = ProtocolVersion.DTLSv12;
                    }
                    if (version == null || 13 + (length = TlsUtils.readUint16((byte[])buf, (int)(off + 11))) > len) break;
                    b = true;
                    break;
                }
            }
        }
        return b;
    }

    public DtlsPacketTransformer(DtlsTransformEngine transformEngine, int componentID) {
        this.transformEngine = transformEngine;
        this.componentID = componentID;
    }

    @Override
    public synchronized void close() {
        this.setConnector(null);
        this.setMediaType(null);
    }

    private void closeDatagramTransport() {
        if (this.datagramTransport != null) {
            try {
                this.datagramTransport.close();
            }
            catch (IOException ioe) {
                logger.error("Failed to (properly) close " + this.datagramTransport.getClass(), ioe);
            }
            this.datagramTransport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterRunInConnectThreadLoop(int i, DatagramTransport datagramTransport) {
        if (i < 0 || i > 3) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        DtlsPacketTransformer dtlsPacketTransformer = this;
        synchronized (dtlsPacketTransformer) {
            if (i > 0 && i < 2) {
                boolean interrupted = false;
                try {
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (interrupted) {
                    currentThread.interrupt();
                }
            }
            return currentThread.equals(this.connectThread) && datagramTransport.equals(this.datagramTransport);
        }
    }

    DtlsControlImpl getDtlsControl() {
        return this.getTransformEngine().getDtlsControl();
    }

    DtlsTransformEngine getTransformEngine() {
        return this.transformEngine;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleRunInConnectThreadException(IOException ioe, String msg, int i) {
        if (ioe instanceof TlsFatalAlert) {
            TlsFatalAlert tfa = (TlsFatalAlert)ioe;
            short alertDescription = tfa.getAlertDescription();
            if (alertDescription == 10) {
                msg = msg + " Received fatal unexpected message.";
                if (i != 0 && Thread.currentThread().equals(this.connectThread) && this.connector != null && this.mediaType != null) {
                    msg = msg + " Will retry.";
                    logger.error(msg, ioe);
                    return true;
                }
                msg = msg + " Giving up after " + (3 - i) + " retries.";
            } else {
                msg = msg + " Received fatal alert " + alertDescription + ".";
            }
        }
        logger.error(msg, ioe);
        return false;
    }

    private SinglePacketTransformer initializeSRTPTransformer(int srtpProtectionProfile, TlsContext tlsContext) {
        SRTPContextFactory reverseSRTPContextFactory;
        SRTPContextFactory forwardSRTPContextFactory;
        int RTP_auth_tag_length;
        int RTCP_auth_tag_length;
        int auth_key_length;
        int auth_function;
        int cipher;
        int cipher_salt_length;
        int cipher_key_length;
        boolean rtcp;
        switch (this.componentID) {
            case 2: {
                rtcp = true;
                break;
            }
            case 1: {
                rtcp = false;
                break;
            }
            default: {
                throw new IllegalStateException("componentID");
            }
        }
        switch (srtpProtectionProfile) {
            case 2: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 1: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            case 6: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 5: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("srtpProtectionProfile");
            }
        }
        byte[] keyingMaterial = tlsContext.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (cipher_key_length + cipher_salt_length));
        byte[] client_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] server_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] client_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[] server_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[][] keyingMaterialValues = new byte[][]{client_write_SRTP_master_key, server_write_SRTP_master_key, client_write_SRTP_master_salt, server_write_SRTP_master_salt};
        int keyingMaterialOffset = 0;
        for (int i = 0; i < keyingMaterialValues.length; ++i) {
            byte[] keyingMaterialValue = keyingMaterialValues[i];
            System.arraycopy(keyingMaterial, keyingMaterialOffset, keyingMaterialValue, 0, keyingMaterialValue.length);
            keyingMaterialOffset += keyingMaterialValue.length;
        }
        SRTPPolicy srtcpPolicy = new SRTPPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTCP_auth_tag_length, cipher_salt_length);
        SRTPPolicy srtpPolicy = new SRTPPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTP_auth_tag_length, cipher_salt_length);
        SRTPContextFactory clientSRTPContextFactory = new SRTPContextFactory(tlsContext instanceof TlsClientContext, client_write_SRTP_master_key, client_write_SRTP_master_salt, srtpPolicy, srtcpPolicy);
        SRTPContextFactory serverSRTPContextFactory = new SRTPContextFactory(tlsContext instanceof TlsServerContext, server_write_SRTP_master_key, server_write_SRTP_master_salt, srtpPolicy, srtcpPolicy);
        if (tlsContext instanceof TlsClientContext) {
            forwardSRTPContextFactory = clientSRTPContextFactory;
            reverseSRTPContextFactory = serverSRTPContextFactory;
        } else if (tlsContext instanceof TlsServerContext) {
            forwardSRTPContextFactory = serverSRTPContextFactory;
            reverseSRTPContextFactory = clientSRTPContextFactory;
        } else {
            throw new IllegalArgumentException("tlsContext");
        }
        SinglePacketTransformer srtpTransformer = rtcp ? new SRTCPTransformer(forwardSRTPContextFactory, reverseSRTPContextFactory) : new SRTPTransformer(forwardSRTPContextFactory, reverseSRTPContextFactory);
        return srtpTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        int len;
        int off;
        byte[] buf = pkt.getBuffer();
        if (DtlsPacketTransformer.isDtlsRecord(buf, off = pkt.getOffset(), len = pkt.getLength())) {
            boolean receive;
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                if (this.datagramTransport == null) {
                    receive = false;
                } else {
                    this.datagramTransport.queueReceive(buf, off, len);
                    receive = true;
                }
            }
            if (receive) {
                DTLSTransport dtlsTransport = this.dtlsTransport;
                if (dtlsTransport == null) {
                    pkt = null;
                } else {
                    try {
                        int receiveLimit = dtlsTransport.getReceiveLimit();
                        int delta = receiveLimit - len;
                        if (delta > 0) {
                            pkt.grow(delta);
                            buf = pkt.getBuffer();
                            off = pkt.getOffset();
                            len = pkt.getLength();
                        } else if (delta < 0) {
                            pkt.shrink(-delta);
                            buf = pkt.getBuffer();
                            off = pkt.getOffset();
                            len = pkt.getLength();
                        }
                        int received = dtlsTransport.receive(buf, off, len, -1);
                        if (received <= 0) {
                            pkt = null;
                        } else {
                            delta = len - received;
                            if (delta > 0) {
                                pkt.shrink(delta);
                            }
                            if (!this.transformEngine.isSrtpDisabled()) {
                                pkt = null;
                            }
                        }
                    }
                    catch (IOException ioe) {
                        pkt = null;
                        logger.error("Failed to decode a DTLS record!", ioe);
                    }
                }
            } else {
                pkt = null;
            }
        } else if (this.transformEngine.isSrtpDisabled()) {
            pkt = null;
        } else {
            SinglePacketTransformer srtpTransformer = this.srtpTransformer;
            if (srtpTransformer != null) {
                pkt = srtpTransformer.reverseTransform(pkt);
            }
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInConnectThread(DTLSProtocol dtlsProtocol, TlsPeer tlsPeer, DatagramTransport datagramTransport) {
        boolean closeSRTPTransformer;
        int i;
        DTLSTransport dtlsTransport = null;
        int srtpProtectionProfile = 0;
        TlsContext tlsContext = null;
        if (dtlsProtocol instanceof DTLSClientProtocol) {
            DTLSClientProtocol dtlsClientProtocol = (DTLSClientProtocol)dtlsProtocol;
            TlsClientImpl tlsClient = (TlsClientImpl)tlsPeer;
            for (i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    dtlsTransport = dtlsClientProtocol.connect((TlsClient)tlsClient, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (!this.handleRunInConnectThreadException(ioe, "Failed to connect this DTLS client to a DTLS server!", i)) break;
                    continue;
                }
            }
            if (dtlsTransport != null && !this.transformEngine.isSrtpDisabled()) {
                srtpProtectionProfile = tlsClient.getChosenProtectionProfile();
                tlsContext = tlsClient.getContext();
            }
        } else if (dtlsProtocol instanceof DTLSServerProtocol) {
            DTLSServerProtocol dtlsServerProtocol = (DTLSServerProtocol)dtlsProtocol;
            TlsServerImpl tlsServer = (TlsServerImpl)tlsPeer;
            for (i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    dtlsTransport = dtlsServerProtocol.accept((TlsServer)tlsServer, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (!this.handleRunInConnectThreadException(ioe, "Failed to accept a connection from a DTLS client!", i)) break;
                    continue;
                }
            }
            if (dtlsTransport != null && !this.transformEngine.isSrtpDisabled()) {
                srtpProtectionProfile = tlsServer.getChosenProtectionProfile();
                tlsContext = tlsServer.getContext();
            }
        } else {
            throw new IllegalStateException("dtlsProtocol");
        }
        SinglePacketTransformer srtpTransformer = dtlsTransport == null || this.transformEngine.isSrtpDisabled() ? null : this.initializeSRTPTransformer(srtpProtectionProfile, tlsContext);
        DtlsPacketTransformer dtlsPacketTransformer = this;
        synchronized (dtlsPacketTransformer) {
            if (Thread.currentThread().equals(this.connectThread) && datagramTransport.equals(this.datagramTransport)) {
                this.dtlsTransport = dtlsTransport;
                this.srtpTransformer = srtpTransformer;
                this.notifyAll();
            }
            closeSRTPTransformer = this.srtpTransformer != srtpTransformer;
        }
        if (closeSRTPTransformer && srtpTransformer != null) {
            srtpTransformer.close();
        }
    }

    void setConnector(AbstractRTPConnector connector) {
        if (this.connector != connector) {
            this.connector = connector;
            DatagramTransportImpl datagramTransport = this.datagramTransport;
            if (datagramTransport != null) {
                datagramTransport.setConnector(connector);
            }
        }
    }

    synchronized void setMediaType(MediaType mediaType) {
        if (this.mediaType != mediaType) {
            if (this.mediaType != null) {
                this.stop();
            }
            this.mediaType = mediaType;
            if (this.mediaType != null) {
                this.start();
            }
        }
    }

    void setSetup(DtlsControl.Setup setup) {
        if (this.setup != setup) {
            this.setup = setup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void start() {
        Object tlsPeer;
        DTLSClientProtocol dtlsProtocolObj;
        if (this.datagramTransport != null) {
            if (this.connectThread == null && this.dtlsTransport == null) {
                logger.warn(this.getClass().getName() + " has been started but has failed to establish" + " the DTLS connection!");
            }
            return;
        }
        AbstractRTPConnector connector = this.connector;
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        DtlsControl.Setup setup = this.setup;
        SecureRandom secureRandom = new SecureRandom();
        if (DtlsControl.Setup.ACTIVE.equals((Object)setup)) {
            dtlsProtocolObj = new DTLSClientProtocol(secureRandom);
            tlsPeer = new TlsClientImpl(this);
        } else {
            dtlsProtocolObj = new DTLSServerProtocol(secureRandom);
            tlsPeer = new TlsServerImpl(this);
        }
        DatagramTransportImpl datagramTransport = new DatagramTransportImpl(this.componentID);
        datagramTransport.setConnector(connector);
        Thread connectThread = new Thread((DTLSProtocol)dtlsProtocolObj, (TlsPeer)tlsPeer, datagramTransport){
            final /* synthetic */ DTLSProtocol val$dtlsProtocolObj;
            final /* synthetic */ TlsPeer val$tlsPeer;
            final /* synthetic */ DatagramTransportImpl val$datagramTransport;
            {
                this.val$dtlsProtocolObj = dTLSProtocol;
                this.val$tlsPeer = tlsPeer;
                this.val$datagramTransport = datagramTransportImpl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DtlsPacketTransformer.this.runInConnectThread(this.val$dtlsProtocolObj, this.val$tlsPeer, this.val$datagramTransport);
                }
                finally {
                    if (Thread.currentThread().equals(DtlsPacketTransformer.this.connectThread)) {
                        DtlsPacketTransformer.this.connectThread = null;
                    }
                }
            }
        };
        connectThread.setDaemon(true);
        connectThread.setName(DtlsPacketTransformer.class.getName() + ".connectThread");
        this.connectThread = connectThread;
        this.datagramTransport = datagramTransport;
        boolean started = false;
        try {
            connectThread.start();
            started = true;
        }
        finally {
            if (!started) {
                if (connectThread.equals(this.connectThread)) {
                    this.connectThread = null;
                }
                if (datagramTransport.equals(this.datagramTransport)) {
                    this.datagramTransport = null;
                }
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop() {
        if (this.connectThread != null) {
            this.connectThread = null;
        }
        try {
            if (this.dtlsTransport != null) {
                try {
                    this.dtlsTransport.close();
                }
                catch (IOException ioe) {
                    logger.error("Failed to (properly) close " + this.dtlsTransport.getClass(), ioe);
                }
                this.dtlsTransport = null;
            }
            if (this.srtpTransformer != null) {
                this.srtpTransformer.close();
                this.srtpTransformer = null;
            }
        }
        finally {
            try {
                this.closeDatagramTransport();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        int len;
        int off;
        byte[] buf = pkt.getBuffer();
        if (DtlsPacketTransformer.isDtlsRecord(buf, off = pkt.getOffset(), len = pkt.getLength())) {
            return pkt;
        }
        if (!this.transformEngine.isSrtpDisabled()) {
            SinglePacketTransformer srtpTransformer = this.srtpTransformer;
            if (srtpTransformer != null) {
                pkt = srtpTransformer.transform(pkt);
            }
        } else {
            pkt = null;
            DTLSTransport dtlsTransport = this.dtlsTransport;
            if (dtlsTransport != null) {
                try {
                    dtlsTransport.send(buf, off, len);
                }
                catch (IOException ioe) {
                    logger.error("Failed to send application data over DTLS transport!", ioe);
                }
            }
        }
        return pkt;
    }
}

