/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.lang.reflect.UndeclaredThrowableException;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.rest.HandlerImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class RESTBundleActivator
implements BundleActivator {
    private static final String JETTY_PORT_PNAME = "org.jitsi.videobridge.rest.jetty.port";
    private static final Logger logger = Logger.getLogger(RESTBundleActivator.class);
    private Server server;

    public void start(BundleContext bundleContext) throws Exception {
        boolean start;
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        int jettyPort = 8080;
        if (cfg == null) {
            start = Boolean.getBoolean("org.jitsi.videobridge.rest");
            jettyPort = Integer.getInteger(JETTY_PORT_PNAME, jettyPort);
        } else {
            start = cfg.getBoolean("org.jitsi.videobridge.rest", false);
            jettyPort = cfg.getInt(JETTY_PORT_PNAME, jettyPort);
        }
        if (!start) {
            return;
        }
        try {
            Server server = new Server(jettyPort);
            server.setHandler((Handler)new HandlerImpl(bundleContext));
            server.start();
            this.server = server;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to start the REST API of Jitsi Videobridge.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

