/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.rtp.SessionAddress;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RTPConnectorUDPImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.WebRtcDataStream;

public class SctpConnection
extends Channel
implements SctpDataCallback,
SctpSocket.NotificationListener {
    private static final Logger logger = Logger.getLogger(SctpConnection.class);
    static final int WEB_RTC_PPID_CTRL = 50;
    static final int WEB_RTC_PPID_STRING = 51;
    static final int WEB_RTC_PPID_BIN = 53;
    private static final int MSG_OPEN_CHANNEL = 3;
    private static final int MSG_CHANNEL_ACK = 2;
    private static final boolean LOG_SCTP_PACKETS = false;
    private static final int DTLS_BUFFER_SIZE = 2048;
    private static final int SCTP_BUFFER_SIZE = 2035;
    private final DtlsControlImpl dtlsControl;
    private int remoteSctpPort;
    private SctpSocket sctpSocket;
    private boolean ready;
    private boolean started;
    private List<WebRtcDataStreamListener> listenerList = new ArrayList<WebRtcDataStreamListener>();
    private HashMap<Integer, WebRtcDataStream> channels = new HashMap();
    private static int debugIdGen = -1;
    private final int debugId;
    private DatagramSocket iceUdpSocket;

    public SctpConnection(Content content, Endpoint endpoint, int remoteSctpPort) throws Exception {
        super(content);
        this.setEndpoint(endpoint.getID());
        this.remoteSctpPort = remoteSctpPort;
        this.dtlsControl = new DtlsControlImpl(true);
        this.debugId = SctpConnection.generateDebugId();
    }

    private static synchronized int generateDebugId() {
        return debugIdGen += 2;
    }

    public String getID() {
        return "SCTP_with_" + this.getEndpoint().getID();
    }

    public boolean isReady() {
        return this.ready;
    }

    protected DtlsControl getDtlsControl() {
        return this.dtlsControl;
    }

    protected synchronized void maybeStartStream() throws IOException {
        if (this.started) {
            return;
        }
        final StreamConnector connector = this.createStreamConnector();
        if (connector == null) {
            return;
        }
        this.dtlsControl.setSetup(this.isInitiator() ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
        this.dtlsControl.start(MediaType.DATA);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block8: {
                    Sctp.init();
                    SctpConnection.this.runOnDtlsTransport(connector);
                    Object var3_1 = null;
                    try {
                        Sctp.finish();
                    }
                    catch (IOException e2) {
                        logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                    }
                    break block8;
                    {
                        catch (IOException e) {
                            logger.error((Object)e, (Throwable)e);
                            Object var3_2 = null;
                            try {
                                Sctp.finish();
                            }
                            catch (IOException e2) {
                                logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        try {
                            Sctp.finish();
                        }
                        catch (IOException e2) {
                            logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
            }
        }, "SctpConnectionReceiveThread").start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnDtlsTransport(StreamConnector connector) throws IOException {
        RTPConnectorUDPImpl rtpConnector = new RTPConnectorUDPImpl(connector);
        MediaStreamTarget streamTarget = this.createStreamTarget();
        rtpConnector.addTarget(new SessionAddress(streamTarget.getDataAddress().getAddress(), streamTarget.getDataAddress().getPort()));
        this.dtlsControl.setConnector((AbstractRTPConnector)rtpConnector);
        DtlsTransformEngine engine = (DtlsTransformEngine)this.dtlsControl.getTransformEngine();
        final DtlsPacketTransformer transformer = (DtlsPacketTransformer)engine.getRTPTransformer();
        byte[] receiveBuffer = new byte[2035];
        SctpConnection sctpConnection = this;
        synchronized (sctpConnection) {
            this.sctpSocket = Sctp.createSocket((int)5000);
        }
        this.sctpSocket.setLink(new NetworkLink(){
            private final RawPacket rawPacket = new RawPacket();

            public void onConnOut(SctpSocket s, byte[] packet) throws IOException {
                this.rawPacket.setBuffer(packet);
                this.rawPacket.setLength(packet.length);
                transformer.transform(this.rawPacket);
            }
        });
        logger.info((Object)("Connecting SCTP to port: " + this.remoteSctpPort + " to " + this.getEndpoint().getID()));
        this.sctpSocket.setNotificationListener((SctpSocket.NotificationListener)this);
        this.sctpSocket.listen();
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (!SctpConnection.this.sctpSocket.accept()) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error accepting SCTP connection", (Throwable)e);
                }
            }
        }, "SctpAcceptThread").start();
        this.sctpSocket.setDataCallback((SctpDataCallback)this);
        this.iceUdpSocket = rtpConnector.getDataSocket();
        DatagramPacket rcvPacket = new DatagramPacket(receiveBuffer, 0, receiveBuffer.length);
        try {
            while (true) {
                this.iceUdpSocket.receive(rcvPacket);
                RawPacket raw = new RawPacket(rcvPacket.getData(), rcvPacket.getOffset(), rcvPacket.getLength());
                raw = transformer.reverseTransform(raw);
                if (raw == null) continue;
                this.sctpSocket.onConnIn(raw.getBuffer(), raw.getOffset(), raw.getLength());
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_11 = null;
                if (this.sctpSocket == null) break block6;
                this.sctpSocket.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (ppid == 50L) {
            try {
                this.onCtrlPacket(data, sid);
            }
            catch (IOException e) {
                logger.error((Object)"IOException when processing ctrl packet", (Throwable)e);
            }
        } else if (ppid == 51L || ppid == 53L) {
            WebRtcDataStream channel;
            SctpConnection sctpConnection = this;
            synchronized (sctpConnection) {
                channel = this.channels.get(sid);
            }
            if (channel == null) {
                logger.error((Object)("No channel found for sid: " + sid));
                return;
            }
            if (ppid == 51L) {
                channel.onStringMsg(new String(data));
            } else {
                channel.onBinaryMsg(data);
            }
        } else {
            logger.warn((Object)("Got message on unsupported PPID: " + ppid));
        }
    }

    private synchronized void onCtrlPacket(byte[] data, int sid) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte messageType = buffer.get();
        if (messageType == 2) {
            logger.info((Object)(this.getEndpoint().getID() + " ACK received SID: " + sid));
            WebRtcDataStream channel = this.channels.get(sid);
            if (channel != null) {
                if (!channel.isAcknowledged()) {
                    channel.ackReceived();
                    this.notifyChannelOpened(channel);
                } else {
                    logger.warn((Object)("Redundant ACK received for SID: " + sid));
                }
            } else {
                logger.error((Object)("No channel exists on sid: " + sid));
            }
        } else if (messageType == 3) {
            byte channelType = buffer.get();
            short priority = buffer.getShort();
            long reliability = buffer.getInt();
            short labelLength = buffer.getShort();
            short protocolLength = buffer.getShort();
            byte[] labelRaw = new byte[labelLength];
            buffer.get(labelRaw);
            String label = new String(labelRaw);
            byte[] protocolRaw = new byte[protocolLength];
            buffer.get(protocolRaw);
            String protocol = new String(protocolRaw);
            logger.info((Object)("!!! " + this.getEndpoint().getID() + " data channel open request" + " on SID: " + sid + " type: " + channelType + " prio: " + priority + " reliab: " + reliability + " label: " + label + " proto: " + protocol));
            if (this.channels.containsKey(sid)) {
                logger.error((Object)("Channel on sid: " + sid + " already exists"));
            }
            WebRtcDataStream newChannel = new WebRtcDataStream(this.sctpSocket, sid, label, true);
            this.channels.put(sid, newChannel);
            this.sendOpenChannelAck(sid);
            this.notifyChannelOpened(newChannel);
        } else {
            logger.error((Object)("Unexpected ctrl msg type: " + messageType));
        }
    }

    private void sendOpenChannelAck(int sid) throws IOException {
        byte[] ack = new byte[]{2};
        int sendAck = this.sctpSocket.send(ack, true, sid, 50);
        if (sendAck != ack.length) {
            logger.error((Object)"Failed to send open channel confirmation");
        }
    }

    public synchronized WebRtcDataStream openChannel(int type, int prio, long reliab, int sid, String label) throws IOException {
        int sentCount;
        if (this.channels.containsKey(sid)) {
            throw new IOException("Channel on sid: " + sid + " already exists");
        }
        ByteBuffer packet = ByteBuffer.allocate(14 + label.length());
        packet.put((byte)3);
        packet.put((byte)type);
        packet.putShort((short)prio);
        packet.putInt((int)reliab);
        packet.putShort((short)label.length());
        packet.putShort((short)0);
        if (label.length() > 0) {
            packet.put(label.getBytes("UTF8"));
        }
        if ((sentCount = this.sctpSocket.send(packet.array(), true, sid, 50)) != packet.capacity()) {
            throw new IOException("Failed to open new chanel on sid: " + sid);
        }
        WebRtcDataStream channel = new WebRtcDataStream(this.sctpSocket, sid, label, false);
        this.channels.put(sid, channel);
        return channel;
    }

    private void notifyChannelOpened(WebRtcDataStream dataChannel) {
        for (WebRtcDataStreamListener l : this.listenerList) {
            l.onChannelOpened(dataChannel);
        }
    }

    private void notifySctpConnectionReady() {
        for (WebRtcDataStreamListener l : this.listenerList) {
            l.onSctpConnectionReady();
        }
    }

    public void addChannelListener(WebRtcDataStreamListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeChannelListener(WebRtcDataStreamListener l) {
        this.listenerList.remove(l);
    }

    protected void onEndpointChanged(Endpoint oldValue, Endpoint newValue) {
        if (oldValue != null) {
            oldValue.setSctpConnection(null);
        }
        if (newValue != null) {
            newValue.setSctpConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStream() throws IOException {
        try {
            SctpConnection sctpConnection = this;
            synchronized (sctpConnection) {
                if (this.sctpSocket != null) {
                    this.sctpSocket.close();
                }
                this.sctpSocket = null;
            }
            Object var4_3 = null;
            if (this.iceUdpSocket != null) {
                this.iceUdpSocket.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.iceUdpSocket != null) {
                this.iceUdpSocket.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRtcDataStream getDefaultDataStream() throws IOException {
        SctpConnection sctpConnection = this;
        synchronized (sctpConnection) {
            if (this.sctpSocket == null) {
                return null;
            }
            WebRtcDataStream def = this.channels.get(0);
            if (def == null) {
                def = this.openChannel(0, 0, 0L, 0, "default");
            }
            return def.isAcknowledged() ? def : null;
        }
    }

    public synchronized void onSctpNotification(SctpSocket socket, SctpNotification notification) {
        logger.info((Object)("Socket(" + socket + ") " + notification));
        if (notification.sn_type == 1) {
            SctpNotification.AssociationChange assocChange = (SctpNotification.AssociationChange)notification;
            switch (assocChange.state) {
                case 1: {
                    this.ready = true;
                    this.notifySctpConnectionReady();
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.ready = false;
                    try {
                        this.closeStream();
                        break;
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error closing sctp socket", (Throwable)e);
                    }
                }
            }
        }
    }

    public static interface WebRtcDataStreamListener {
        public void onSctpConnectionReady();

        public void onChannelOpened(WebRtcDataStream var1);
    }
}

