/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.media.rtp.SessionAddress;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpRawPacket;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RTCPFeedbackMessageSender;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpChannel
extends Channel
implements PropertyChangeListener {
    private static final long[] NO_RECEIVE_SSRCS = new long[0];
    private ConferenceSpeechActivity conferenceSpeechActivity;
    private CsrcAudioLevelListener csrcAudioLevelListener;
    private final String id;
    private final long initialLocalSSRC;
    private Integer lastN;
    private List<WeakReference<Endpoint>> lastNEndpoints;
    private final Object lastNSyncRoot = new Object();
    private long[] receiveSSRCs = NO_RECEIVE_SSRCS;
    private RTPLevelRelayType rtpLevelRelayType;
    private final SSRCFactoryImpl ssrcFactory = new SSRCFactoryImpl();
    private final MediaStream stream;
    private SimpleAudioLevelListener streamAudioLevelListener;
    private final PropertyChangeListener streamPropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            RtpChannel.this.streamPropertyChange(ev);
        }
    };
    private final SessionAddress streamTarget = new SessionAddress();

    static RtpChannel getChannel(MediaStream stream) {
        return (RtpChannel)stream.getProperty(RtpChannel.class.getName());
    }

    public final MediaStream getMediaStream() {
        return this.stream;
    }

    public RtpChannel(Content content, String id) throws Exception {
        super(content);
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        MediaService mediaService = this.getMediaService();
        MediaType mediaType = this.getContent().getMediaType();
        this.stream = mediaService.createMediaStream(null, mediaType, mediaService.createSrtpControl(SrtpControlType.DTLS_SRTP));
        this.stream.addPropertyChangeListener(this.streamPropertyChangeListener);
        this.stream.setName(this.id);
        this.stream.setProperty(RtpChannel.class.getName(), (Object)this);
        this.stream.setSSRCFactory((SSRCFactory)this.ssrcFactory);
        this.initialLocalSSRC = (long)this.ssrcFactory.doGenerateSSRC() & 0xFFFFFFFFL;
        this.conferenceSpeechActivity = this.getContent().getConference().getSpeechActivity();
        if (this.conferenceSpeechActivity != null) {
            this.conferenceSpeechActivity.addPropertyChangeListener((PropertyChangeListener)new WeakReferencePropertyChangeListener((PropertyChangeListener)this));
        }
        this.touch();
    }

    private boolean acceptControlInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress ctrlAddr = this.streamTarget.getControlAddress();
        int ctrlPort = this.streamTarget.getControlPort();
        if (ctrlAddr == null) {
            this.streamTarget.setControlHostAddress(p.getAddress());
            this.streamTarget.setControlPort(p.getPort());
            InetAddress dataAddr = this.streamTarget.getDataAddress();
            int dataPort = this.streamTarget.getDataPort();
            if (dataAddr != null) {
                ctrlAddr = this.streamTarget.getControlAddress();
                ctrlPort = this.streamTarget.getControlPort();
                this.stream.setTarget(new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort));
            }
            accept = true;
        } else {
            boolean bl = accept = ctrlAddr.equals(p.getAddress()) && ctrlPort == p.getPort();
        }
        if (accept) {
            int ssrc;
            int sc;
            int offset;
            byte[] data;
            byte b0;
            this.touch();
            if (p.getLength() > 8 && ((b0 = (data = p.getData())[offset = p.getOffset()]) & 0xC0) >>> 6 == 2 && (data[offset + 1] & 0xFF) == 203 && (sc = b0 & 0x1F) > 0 && this.removeReceiveSSRC(ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(offset + 4)))) {
                this.notifyFocus();
            }
        }
        return accept;
    }

    private boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress dataAddr = this.streamTarget.getDataAddress();
        int dataPort = this.streamTarget.getDataPort();
        if (dataAddr == null) {
            this.streamTarget.setDataHostAddress(p.getAddress());
            this.streamTarget.setDataPort(p.getPort());
            dataAddr = this.streamTarget.getDataAddress();
            dataPort = this.streamTarget.getDataPort();
            InetAddress ctrlAddr = this.streamTarget.getControlAddress();
            int ctrlPort = this.streamTarget.getControlPort();
            MediaStreamTarget newStreamTarget = ctrlAddr == null ? new MediaStreamTarget(new InetSocketAddress(dataAddr, dataPort), null) : new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort);
            this.stream.setTarget(newStreamTarget);
            accept = true;
        } else {
            boolean bl = accept = dataAddr.equals(p.getAddress()) && dataPort == p.getPort();
        }
        if (accept) {
            this.touch();
            if (p.getLength() >= 12) {
                int off;
                byte[] data = p.getData();
                int v = (data[off = p.getOffset()] & 0xC0) >>> 6;
                if (v == 0) {
                    byte[] zrtpMagicCookie;
                    if ((data[off] & 0x10) == 16 && data[off + 4] == (zrtpMagicCookie = ZrtpRawPacket.ZRTP_MAGIC)[0] && data[off + 5] == zrtpMagicCookie[1] && data[off + 6] == zrtpMagicCookie[2] && data[off + 7] == zrtpMagicCookie[3]) {
                        accept = false;
                    }
                } else if (v == 2) {
                    int pt;
                    MediaFormat format;
                    Map payloadTypes;
                    int ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(off + 8));
                    boolean notify = this.addReceiveSSRC(ssrc);
                    if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType()) && (payloadTypes = this.stream.getDynamicRTPPayloadTypes()) != null && (format = (MediaFormat)payloadTypes.get((byte)(pt = data[off + 1] & 0x7F))) != null && !format.equals((Object)this.stream.getFormat())) {
                        this.stream.setFormat(format);
                        this.stream.setDirection(MediaDirection.SENDRECV);
                        notify = true;
                    }
                    if (notify) {
                        this.notifyFocus();
                    }
                }
            }
        }
        return accept;
    }

    private synchronized boolean addReceiveSSRC(int receiveSSRC) {
        long now = System.currentTimeMillis();
        int length = this.receiveSSRCs.length;
        for (int i = 0; i < length; i += 2) {
            if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
            this.receiveSSRCs[i + 1] = now;
            return false;
        }
        long[] newReceiveSSRCs = new long[length + 2];
        System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, length);
        newReceiveSSRCs[length] = 0xFFFFFFFFL & (long)receiveSSRC;
        newReceiveSSRCs[length + 1] = now;
        this.receiveSSRCs = newReceiveSSRCs;
        return true;
    }

    void askForKeyframes() {
        RTCPFeedbackMessageSender rtcpFeedbackMessageSender;
        int[] receiveSSRCs = this.getReceiveSSRCs();
        if (receiveSSRCs.length != 0 && (rtcpFeedbackMessageSender = this.getContent().getRTCPFeedbackMessageSender()) != null) {
            rtcpFeedbackMessageSender.sendFIR(this.stream, receiveSSRCs);
        }
    }

    @Override
    protected void closeStream() {
        this.stream.setProperty(Channel.class.getName(), null);
        this.removeStreamListeners();
        this.stream.close();
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        super.describe(commonIq);
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        iq.setRTPLevelRelayType(this.getRTPLevelRelayType());
        iq.setDirection(this.stream.getDirection());
        iq.setID(this.getID());
        iq.setLastN(this.lastN);
        long initialLocalSSRC = this.getInitialLocalSSRC();
        if (initialLocalSSRC != -1L) {
            SourcePacketExtension source = new SourcePacketExtension();
            source.setSSRC(initialLocalSSRC);
            iq.addSource(source);
        }
        iq.setSSRCs(this.getReceiveSSRCs());
    }

    private void dominantSpeakerChanged() {
    }

    private void endpointsEnteringLastN(List<Endpoint> endpoints) {
    }

    private CsrcAudioLevelListener getCsrcAudioLevelListener() {
        if (this.csrcAudioLevelListener == null) {
            this.csrcAudioLevelListener = new CsrcAudioLevelListener(){

                public void audioLevelsReceived(long[] levels) {
                    RtpChannel.this.streamAudioLevelsReceived(levels);
                }
            };
        }
        return this.csrcAudioLevelListener;
    }

    @Override
    protected DtlsControl getDtlsControl() {
        SrtpControl srtpControl = this.stream.getSrtpControl();
        if (srtpControl instanceof DtlsControl) {
            return (DtlsControl)srtpControl;
        }
        return null;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    private long getInitialLocalSSRC() {
        return RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType()) ? this.initialLocalSSRC : -1L;
    }

    private MediaService getMediaService() {
        return this.getContent().getMediaService();
    }

    public synchronized int[] getReceiveSSRCs() {
        int length = this.receiveSSRCs.length;
        if (length == 0) {
            return ColibriConferenceIQ.NO_SSRCS;
        }
        int[] receiveSSRCs = new int[length / 2];
        int src = 0;
        int dst = 0;
        while (src < length) {
            receiveSSRCs[dst] = (int)this.receiveSSRCs[src];
            src += 2;
            ++dst;
        }
        return receiveSSRCs;
    }

    public RTPLevelRelayType getRTPLevelRelayType() {
        if (this.rtpLevelRelayType == null) {
            this.setRTPLevelRelayType(RTPLevelRelayType.TRANSLATOR);
        }
        return this.rtpLevelRelayType;
    }

    private SimpleAudioLevelListener getStreamAudioLevelListener() {
        if (this.streamAudioLevelListener == null) {
            this.streamAudioLevelListener = new SimpleAudioLevelListener(){

                public void audioLevelChanged(int level) {
                    RtpChannel.this.streamAudioLevelChanged(level);
                }
            };
        }
        return this.streamAudioLevelListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInLastN(Channel channel) {
        Integer lastNInteger = this.lastN;
        if (lastNInteger == null) {
            return true;
        }
        int lastNInt = lastNInteger;
        if (lastNInt < 0) {
            return true;
        }
        Endpoint channelEndpoint = channel.getEndpoint();
        if (channelEndpoint == null) {
            return true;
        }
        ConferenceSpeechActivity conferenceSpeechActivity = this.conferenceSpeechActivity;
        if (conferenceSpeechActivity == null) {
            return true;
        }
        if (lastNInt == 0) {
            return false;
        }
        Endpoint thisEndpoint = this.getEndpoint();
        boolean inLastN = false;
        Object object = this.lastNSyncRoot;
        synchronized (object) {
            if (this.lastNEndpoints == null) {
                List<Endpoint> endpoints = conferenceSpeechActivity.getEndpoints();
                this.lastNEndpoints = new ArrayList<WeakReference<Endpoint>>(endpoints.size());
                for (Endpoint endpoint : endpoints) {
                    this.lastNEndpoints.add(new WeakReference<Endpoint>(endpoint));
                }
            }
            if (this.lastNEndpoints != null) {
                int n = 0;
                for (WeakReference weakReference : this.lastNEndpoints) {
                    Endpoint e = (Endpoint)((Object)weakReference.get());
                    if (e != null) {
                        if (((Object)((Object)e)).equals((Object)thisEndpoint)) continue;
                        if (((Object)((Object)e)).equals((Object)channelEndpoint)) {
                            inLastN = true;
                            break;
                        }
                    }
                    if (++n < lastNInt) continue;
                    break;
                }
            }
        }
        return inLastN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Endpoint> lastNEndpointsChanged(List<Endpoint> endpoints) {
        ArrayList<Endpoint> endpointsEnteringLastN = null;
        Endpoint thisEndpoint = this.getEndpoint();
        Object object = this.lastNSyncRoot;
        synchronized (object) {
            int lastNInt;
            Integer lastNInteger = this.lastN;
            int n = lastNInt = lastNInteger == null ? -1 : lastNInteger;
            if (lastNInt > 0) {
                endpointsEnteringLastN = new ArrayList<Endpoint>(lastNInt);
                for (Endpoint e : endpoints) {
                    if (((Object)((Object)e)).equals((Object)thisEndpoint)) continue;
                    endpointsEnteringLastN.add(e);
                    if (endpointsEnteringLastN.size() < lastNInt) continue;
                    break;
                }
                if (this.lastNEndpoints != null) {
                    int n2 = 0;
                    for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                        Endpoint e = (Endpoint)((Object)wr.get());
                        if (e != null) {
                            if (((Object)((Object)e)).equals((Object)thisEndpoint)) continue;
                            endpointsEnteringLastN.remove((Object)e);
                        }
                        if (++n2 < lastNInt) continue;
                        break;
                    }
                }
            }
            this.lastNEndpoints = new ArrayList<WeakReference<Endpoint>>(endpoints.size());
            for (Endpoint endpoint : endpoints) {
                this.lastNEndpoints.add(new WeakReference<Endpoint>(endpoint));
            }
        }
        if (endpointsEnteringLastN != null && !endpointsEnteringLastN.isEmpty()) {
            this.endpointsEnteringLastN(endpointsEnteringLastN);
        }
        return endpointsEnteringLastN;
    }

    @Override
    protected void maybeStartStream() throws IOException {
        StreamConnector connector = this.createStreamConnector();
        if (connector == null) {
            return;
        }
        this.stream.setConnector(connector);
        MediaStreamTarget streamTarget = this.createStreamTarget();
        if (streamTarget != null) {
            InetSocketAddress ctrlAddr;
            InetSocketAddress dataAddr = streamTarget.getDataAddress();
            if (dataAddr != null) {
                this.streamTarget.setDataHostAddress(dataAddr.getAddress());
                this.streamTarget.setDataPort(dataAddr.getPort());
            }
            if ((ctrlAddr = streamTarget.getControlAddress()) != null) {
                this.streamTarget.setControlHostAddress(ctrlAddr.getAddress());
                this.streamTarget.setControlPort(ctrlAddr.getPort());
            }
            if (dataAddr != null) {
                this.stream.setTarget(streamTarget);
            }
        }
        Content content = this.getContent();
        if (!this.stream.isStarted()) {
            SrtpControl srtpControl = this.stream.getSrtpControl();
            if (srtpControl != null) {
                if (srtpControl instanceof DtlsControl) {
                    DtlsControl dtlsControl = (DtlsControl)srtpControl;
                    dtlsControl.setSetup(this.isInitiator() ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
                }
                srtpControl.start(content.getMediaType());
            }
            this.stream.start();
        }
        RtpChannel.logd("Direction of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + " is " + this.stream.getDirection() + ".");
        this.touch();
    }

    private void notifyFocus() {
        block6: {
            Content content = this.getContent();
            Conference conference = content.getConference();
            String focus = conference.getFocus();
            if (focus == null) {
                return;
            }
            Collection<ComponentImpl> components = conference.getVideobridge().getComponents();
            if (!components.isEmpty()) {
                try {
                    ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                    conference.describeShallow(conferenceIQ);
                    ColibriConferenceIQ.Content contentIQ = conferenceIQ.getOrCreateContent(content.getName());
                    ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                    this.describe((ColibriConferenceIQ.ChannelCommon)channelIQ);
                    contentIQ.addChannel(channelIQ);
                    conferenceIQ.setTo(focus);
                    conferenceIQ.setType(IQ.Type.SET);
                    for (ComponentImpl component : components) {
                        component.send((IQ)conferenceIQ);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block6;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    @Override
    protected void onEndpointChanged(Endpoint oldValue, Endpoint newValue) {
        if (oldValue != null) {
            oldValue.removeChannel(this);
        }
        if (newValue != null) {
            newValue.addChannel(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName;
        Object source = ev.getSource();
        if (this.conferenceSpeechActivity == source && this.conferenceSpeechActivity != null && ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName = ev.getPropertyName())) {
            this.dominantSpeakerChanged();
        }
    }

    private synchronized boolean removeReceiveSSRC(int receiveSSRC) {
        boolean removed;
        block4: {
            int length;
            block3: {
                length = this.receiveSSRCs.length;
                removed = false;
                if (length != 2) break block3;
                if ((int)this.receiveSSRCs[0] != receiveSSRC) break block4;
                this.receiveSSRCs = NO_RECEIVE_SSRCS;
                removed = true;
                break block4;
            }
            for (int i = 0; i < length; i += 2) {
                if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
                long[] newReceiveSSRCs = new long[length - 2];
                if (i != 0) {
                    System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, i);
                }
                if (i != newReceiveSSRCs.length) {
                    System.arraycopy(this.receiveSSRCs, i + 2, newReceiveSSRCs, i, newReceiveSSRCs.length - i);
                }
                removed = true;
                break;
            }
        }
        return removed;
    }

    private void removeStreamListeners() {
        block6: {
            try {
                this.stream.removePropertyChangeListener(this.streamPropertyChangeListener);
                if (this.stream instanceof AudioMediaStream) {
                    AudioMediaStream audioStream = (AudioMediaStream)this.stream;
                    CsrcAudioLevelListener csrcAudioLevelListener = this.csrcAudioLevelListener;
                    SimpleAudioLevelListener streamAudioLevelListener = this.streamAudioLevelListener;
                    if (csrcAudioLevelListener != null) {
                        audioStream.setCsrcAudioLevelListener(csrcAudioLevelListener);
                    }
                    if (streamAudioLevelListener != null) {
                        audioStream.setStreamAudioLevelListener(streamAudioLevelListener);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)t;
            }
        }
    }

    boolean rtpTranslatorWillWrite(boolean data, byte[] buffer, int offset, int length, Channel source) {
        boolean accept = true;
        if (data && source != null && MediaType.VIDEO.equals((Object)this.getContent().getMediaType())) {
            accept = this.isInLastN(source);
        }
        return accept;
    }

    public void setDirection(MediaDirection direction) {
        if (this.streamTarget.getDataAddress() != null) {
            this.stream.setDirection(direction);
        }
        this.touch();
    }

    public void setLastN(Integer lastN) {
        this.lastN = lastN;
        this.touch();
    }

    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        MediaService mediaService;
        if (payloadTypes != null && payloadTypes.size() > 0 && (mediaService = this.getMediaService()) != null) {
            boolean googleChrome = false;
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                MediaFormat mediaFormat = JingleUtils.payloadTypeToMediaFormat((PayloadTypePacketExtension)payloadType, (MediaService)mediaService, null);
                if (mediaFormat == null) {
                    if (googleChrome || !"iSAC".equalsIgnoreCase(payloadType.getName())) continue;
                    googleChrome = true;
                    continue;
                }
                this.stream.addDynamicRTPPayloadType((byte)payloadType.getID(), mediaFormat);
            }
            if (googleChrome && this.stream instanceof AudioMediaStream) {
                URI uri;
                try {
                    uri = new URI("urn:ietf:params:rtp-hdrext:ssrc-audio-level");
                }
                catch (URISyntaxException e) {
                    uri = null;
                }
                if (uri != null) {
                    this.stream.addRTPExtension((byte)1, new RTPExtension(uri));
                    ((AudioMediaStream)this.stream).setCsrcAudioLevelListener(this.getCsrcAudioLevelListener());
                }
            }
        }
        this.touch();
    }

    public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
        block10: {
            block9: {
                if (rtpLevelRelayType == null) {
                    throw new NullPointerException("rtpLevelRelayType");
                }
                if (this.rtpLevelRelayType != null) break block9;
                this.rtpLevelRelayType = rtpLevelRelayType;
                switch (this.getRTPLevelRelayType()) {
                    case MIXER: {
                        Content content = this.getContent();
                        MediaDevice device = content.getMixer();
                        this.stream.setDevice(device);
                        if (MediaType.AUDIO.equals((Object)content.getMediaType())) {
                            List rtpExtensions = device.getSupportedExtensions();
                            if (rtpExtensions.size() == 1) {
                                this.stream.addRTPExtension((byte)1, (RTPExtension)rtpExtensions.get(0));
                            }
                            ((AudioMediaStream)this.stream).setStreamAudioLevelListener(this.getStreamAudioLevelListener());
                        }
                        if (this.stream.getFormat() == null) {
                            this.stream.setDirection(MediaDirection.RECVONLY);
                            break;
                        }
                        break block10;
                    }
                    case TRANSLATOR: {
                        this.stream.setRTPTranslator(this.getContent().getRTPTranslator());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("rtpLevelRelayType");
                    }
                }
                break block10;
            }
            if (!this.rtpLevelRelayType.equals((Object)rtpLevelRelayType)) {
                // empty if block
            }
        }
        this.touch();
    }

    private long ssrcFactoryGenerateSSRC(String cause, int i) {
        if (this.initialLocalSSRC != -1L) {
            if (i == 0) {
                return (int)this.initialLocalSSRC;
            }
            if (cause.equals(GenerateSSRCCause.REMOVE_SEND_STREAM.name())) {
                return Long.MAX_VALUE;
            }
        }
        return this.ssrcFactory.doGenerateSSRC();
    }

    private void streamAudioLevelChanged(int level) {
    }

    private void streamAudioLevelsReceived(long[] levels) {
        int[] receiveSSRCs;
        if (levels != null && (receiveSSRCs = this.getReceiveSSRCs()).length != 0) {
            int count = levels.length / 2;
            for (int i = 0; i < count; ++i) {
                ConferenceSpeechActivity conferenceSpeechActivity;
                int i2 = i * 2;
                long ssrc = levels[i2];
                boolean isReceiveSSRC = false;
                for (int receiveSSRC : receiveSSRCs) {
                    if (ssrc != (0xFFFFFFFFL & (long)receiveSSRC)) continue;
                    isReceiveSSRC = true;
                    break;
                }
                if (!isReceiveSSRC || (conferenceSpeechActivity = this.conferenceSpeechActivity) == null) continue;
                int level = (int)levels[i2 + 1];
                conferenceSpeechActivity.levelChanged(this, ssrc, level);
            }
        }
    }

    private void streamPropertyChange(PropertyChangeEvent ev) {
        String rtpConnectorPropertyName;
        Object datagramPacketFilter;
        Object newValue;
        String prefix;
        String propertyName = ev.getPropertyName();
        if (propertyName.startsWith(prefix = MediaStreamImpl.class.getName() + ".rtpConnector.") && (newValue = ev.getNewValue()) instanceof RTPConnectorInputStream && (datagramPacketFilter = (rtpConnectorPropertyName = propertyName.substring(prefix.length())).equals("controlInputStream") ? new DatagramPacketFilter(){

            public boolean accept(DatagramPacket p) {
                return RtpChannel.this.acceptControlInputStreamDatagramPacket(p);
            }
        } : (rtpConnectorPropertyName.equals("dataInputStream") ? new DatagramPacketFilter(){

            public boolean accept(DatagramPacket p) {
                return RtpChannel.this.acceptDataInputStreamDatagramPacket(p);
            }
        } : null)) != null) {
            ((RTPConnectorInputStream)newValue).addDatagramPacketFilter(datagramPacketFilter);
        }
    }

    private class SSRCFactoryImpl
    implements SSRCFactory {
        private int i = 0;
        private final Random random = new Random();

        private SSRCFactoryImpl() {
        }

        public int doGenerateSSRC() {
            return this.random.nextInt();
        }

        public long generateSSRC(String cause) {
            return RtpChannel.this.ssrcFactoryGenerateSSRC(cause, this.i++);
        }
    }
}

