/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RawUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

public abstract class Channel
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(Channel.class);
    public static final int DEFAULT_EXPIRE = 60;
    private static final ExecutorService executorService = ExecutorUtils.newCachedThreadPool((boolean)true, (String)"Channel");
    public static final String INITIATOR_PROPERTY = "initiator";
    private final Content content;
    private Endpoint endpoint;
    private int expire = 60;
    private boolean expired = false;
    private boolean initiator = true;
    private long lastActivityTime;
    private TransportManager transportManager;
    private final Object transportManagerSyncRoot = new Object();
    private WrapupConnectivityEstablishmentCommand wrapupConnectivityEstablishmentCommand;

    public Channel(Content content) throws Exception {
        if (content == null) {
            throw new NullPointerException("content");
        }
        this.content = content;
        this.touch();
    }

    protected static void logd(String s) {
        logger.info((Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamConnector createStreamConnector() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            TransportManager transportManager = this.transportManager;
            return transportManager == null ? null : transportManager.getStreamConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaStreamTarget createStreamTarget() {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            TransportManager transportManager = this.transportManager;
            return transportManager == null ? null : transportManager.getStreamTarget();
        }
    }

    private TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            return new IceUdpTransportManager(this);
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            return new RawUdpTransportManager(this);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            iq.setEndpoint(endpoint.getID());
        }
        iq.setExpire(this.getExpire());
        iq.setInitiator(Boolean.valueOf(this.isInitiator()));
        this.describeTransportManager(iq);
        this.describeSrtpControl(iq);
    }

    private void describeSrtpControl(ColibriConferenceIQ.ChannelCommon iq) {
        DtlsControl dtlsControl = this.getDtlsControl();
        if (dtlsControl != null) {
            DtlsFingerprintPacketExtension fingerprintPE;
            String fingerprint = dtlsControl.getLocalFingerprint();
            String hash = dtlsControl.getLocalFingerprintHashFunction();
            IceUdpTransportPacketExtension transportPE = iq.getTransport();
            if (transportPE == null) {
                transportPE = new RawUdpTransportPacketExtension();
                iq.setTransport(transportPE);
            }
            if ((fingerprintPE = (DtlsFingerprintPacketExtension)transportPE.getFirstChildOfType(DtlsFingerprintPacketExtension.class)) == null) {
                fingerprintPE = new DtlsFingerprintPacketExtension();
                transportPE.addChildExtension((PacketExtension)fingerprintPE);
            }
            fingerprintPE.setFingerprint(fingerprint);
            fingerprintPE.setHash(hash);
        }
    }

    private void describeTransportManager(ColibriConferenceIQ.ChannelCommon iq) {
        TransportManager transportManager;
        try {
            transportManager = this.getTransportManager();
        }
        catch (IOException ioe) {
            throw new UndeclaredThrowableException(ioe);
        }
        if (transportManager != null) {
            transportManager.describe(iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void expire() {
        block23: {
            block22: {
                var1_1 = this;
                synchronized (var1_1) {
                    if (this.expired) {
                        return;
                    }
                    this.expired = true;
                }
                content = this.getContent();
                try {
                    content.expireChannel(this);
                    var4_3 = null;
                    conference = content.getConference();
                }
                catch (Throwable var3_11) {
                    block26: {
                        block25: {
                            block24: {
                                var4_4 = null;
                                conference = content.getConference();
                                try {
                                    this.closeStream();
                                }
                                catch (Throwable t) {
                                    Channel.logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t);
                                    if (!(t instanceof ThreadDeath)) break block24;
                                    throw (ThreadDeath)t;
                                }
                            }
                            try {
                                t = this.transportManagerSyncRoot;
                                synchronized (t) {
                                    this.wrapupConnectivityEstablishmentCommand = null;
                                    if (this.transportManager != null) {
                                        this.transportManager.close();
                                    }
                                }
                            }
                            catch (Throwable t) {
                                Channel.logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t);
                                if (!(t instanceof ThreadDeath)) break block25;
                                throw (ThreadDeath)t;
                            }
                        }
                        try {
                            endpoint = this.getEndpoint();
                            this.onEndpointChanged(endpoint, null);
                        }
                        catch (Throwable t) {
                            if (!(t instanceof ThreadDeath)) break block26;
                            throw (ThreadDeath)t;
                        }
                    }
                    videobridge = conference.getVideobridge();
                    Channel.logd("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
                    throw var3_11;
                }
                try {
                    this.closeStream();
                }
                catch (Throwable t) {
                    Channel.logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t);
                    if (!(t instanceof ThreadDeath)) break block22;
                    throw (ThreadDeath)t;
                }
            }
            try {
                t = this.transportManagerSyncRoot;
                synchronized (t) {
                    this.wrapupConnectivityEstablishmentCommand = null;
                    if (this.transportManager != null) {
                        this.transportManager.close();
                    }
                }
            }
            catch (Throwable t) {
                Channel.logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t);
                if (!(t instanceof ThreadDeath)) break block23;
                throw (ThreadDeath)t;
            }
        }
        try {
            endpoint = this.getEndpoint();
            this.onEndpointChanged(endpoint, null);
        }
        catch (Throwable t) {
            if (!(t instanceof ThreadDeath)) ** GOTO lbl84
            throw (ThreadDeath)t;
        }
lbl84:
        // 2 sources

        videobridge = conference.getVideobridge();
        Channel.logd("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
    }

    protected abstract void closeStream() throws IOException;

    public final Content getContent() {
        return this.content;
    }

    public BundleContext getBundleContext() {
        return this.getContent().getBundleContext();
    }

    protected abstract DtlsControl getDtlsControl();

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public int getExpire() {
        return this.expire;
    }

    public abstract String getID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Channel channel = this;
        synchronized (channel) {
            return this.lastActivityTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransportManager getTransportManager() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (this.transportManager == null) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager = this.createTransportManager(this.getContent().getConference().getVideobridge().getDefaultTransportManager());
                if ("urn:xmpp:jingle:transports:raw-udp:1".equals(this.transportManager.getXmlNamespace())) {
                    this.maybeStartStream();
                }
            }
            return this.transportManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Channel channel = this;
        synchronized (channel) {
            return this.expired;
        }
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    protected abstract void maybeStartStream() throws IOException;

    protected abstract void onEndpointChanged(Endpoint var1, Endpoint var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInWrapupConnectivityEstablishmentCommand(WrapupConnectivityEstablishmentCommand wrapupConnectivityEstablishmentCommand) {
        TransportManager transportManager = wrapupConnectivityEstablishmentCommand.transportManager;
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (wrapupConnectivityEstablishmentCommand != this.wrapupConnectivityEstablishmentCommand) {
                return;
            }
            if (this.isExpired()) {
                return;
            }
        }
        try {
            transportManager.wrapupConnectivityEstablishment();
        }
        catch (OperationFailedException ofe) {
            Content content = this.getContent();
            logger.error((Object)("Failed to wrapup the connectivity establishment of the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + "!"), (Throwable)ofe);
            return;
        }
        object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (wrapupConnectivityEstablishmentCommand != this.wrapupConnectivityEstablishmentCommand) {
                return;
            }
            if (this.isExpired()) {
                return;
            }
            try {
                this.maybeStartStream();
            }
            catch (IOException ioe) {
                Content content = this.getContent();
                logger.error((Object)("Failed to start the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + "!"), (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEndpoint(String endpoint) {
        block8: {
            block7: {
                try {
                    Endpoint newValue;
                    Endpoint oldValue = this.endpoint;
                    if (oldValue == null) {
                        if (endpoint == null) {
                            Object var5_3 = null;
                            this.touch();
                            return;
                        }
                    } else if (oldValue.getID().equals(endpoint)) {
                        break block7;
                    }
                    if (oldValue != (newValue = this.getContent().getConference().getOrCreateEndpoint(endpoint))) {
                        this.endpoint = newValue;
                        this.onEndpointChanged(oldValue, newValue);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.touch();
                    throw throwable;
                }
            }
            Object var5_4 = null;
            this.touch();
            return;
        }
        Object var5_5 = null;
        this.touch();
    }

    public void setExpire(int expire) {
        if (expire < 0) {
            throw new IllegalArgumentException("expire");
        }
        this.expire = expire;
        if (this.expire == 0) {
            this.expire();
        } else {
            this.touch();
        }
    }

    public void setInitiator(boolean initiator) {
        boolean oldValue = this.initiator;
        boolean newValue = this.initiator = initiator;
        this.touch();
        if (oldValue != newValue) {
            DtlsControl dtlsControl = this.getDtlsControl();
            if (dtlsControl != null) {
                dtlsControl.setSetup(this.isInitiator() ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
            }
            this.firePropertyChange(INITIATOR_PROPERTY, oldValue, newValue);
        }
    }

    public void setTransport(IceUdpTransportPacketExtension transport) throws IOException {
        if (transport != null) {
            TransportManager transportManager;
            List dfpes;
            this.setTransportManager(transport.getNamespace());
            DtlsControl dtlsControl = this.getDtlsControl();
            if (dtlsControl != null && !(dfpes = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty()) {
                LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
                for (DtlsFingerprintPacketExtension dfpe : dfpes) {
                    remoteFingerprints.put(dfpe.getHash(), dfpe.getFingerprint());
                }
                dtlsControl.setRemoteFingerprints(remoteFingerprints);
            }
            if ((transportManager = this.getTransportManager()) != null) {
                if (transportManager.startConnectivityEstablishment(transport)) {
                    this.wrapupConnectivityEstablishment(transportManager);
                } else {
                    this.maybeStartStream();
                }
            }
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransportManager(String xmlNamespace) throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (this.transportManager != null && !this.transportManager.getXmlNamespace().equals(xmlNamespace)) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager.close();
                this.transportManager = null;
            }
            if (this.transportManager == null) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager = this.createTransportManager(xmlNamespace);
                Content content = this.getContent();
                Channel.logd("Set " + this.transportManager.getClass().getSimpleName() + " #" + Integer.toHexString(this.transportManager.hashCode()) + " on channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + ".");
            }
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Channel channel = this;
        synchronized (channel) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapupConnectivityEstablishment(TransportManager transportManager) {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (this.wrapupConnectivityEstablishmentCommand != null && this.wrapupConnectivityEstablishmentCommand.transportManager != transportManager) {
                this.wrapupConnectivityEstablishmentCommand = null;
            }
            if (this.wrapupConnectivityEstablishmentCommand == null) {
                this.wrapupConnectivityEstablishmentCommand = new WrapupConnectivityEstablishmentCommand(transportManager);
                boolean execute = false;
                try {
                    executorService.execute(this.wrapupConnectivityEstablishmentCommand);
                    execute = true;
                    Object var5_4 = null;
                    if (!execute) {
                        this.wrapupConnectivityEstablishmentCommand = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!execute) {
                        this.wrapupConnectivityEstablishmentCommand = null;
                    }
                    throw throwable;
                }
            }
        }
    }

    private class WrapupConnectivityEstablishmentCommand
    implements Runnable {
        public final TransportManager transportManager;

        public WrapupConnectivityEstablishmentCommand(TransportManager transportManager) {
            this.transportManager = transportManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Channel.this.runInWrapupConnectivityEstablishmentCommand(this);
            }
            finally {
                Object object = Channel.this.transportManagerSyncRoot;
                synchronized (object) {
                    if (Channel.this.wrapupConnectivityEstablishmentCommand == this) {
                        Channel.this.wrapupConnectivityEstablishmentCommand = null;
                    }
                }
            }
        }
    }
}

