/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.partition.BackupSafeMemberGroupFactory;
import com.hazelcast.partition.DefaultMemberGroup;
import com.hazelcast.partition.MemberGroup;
import com.hazelcast.partition.MemberGroupFactory;
import com.hazelcast.util.AddressUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConfigMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    private final Map<Integer, MemberGroupConfig> memberGroupConfigMap = new LinkedHashMap<Integer, MemberGroupConfig>();

    public ConfigMemberGroupFactory(Collection<MemberGroupConfig> memberGroupConfigs) {
        int key = 0;
        for (MemberGroupConfig groupConfig : memberGroupConfigs) {
            this.memberGroupConfigMap.put(key++, groupConfig);
        }
    }

    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<Member> members) {
        HashMap<Integer, MemberGroup> memberGroups = new HashMap<Integer, MemberGroup>();
        block0: for (Member member : members) {
            for (Map.Entry<Integer, MemberGroupConfig> groupConfigEntry : this.memberGroupConfigMap.entrySet()) {
                if (!AddressUtil.matchAnyInterface(((MemberImpl)member).getAddress().getHost(), groupConfigEntry.getValue().getInterfaces())) continue;
                MemberGroup group = (MemberGroup)memberGroups.get(groupConfigEntry.getKey());
                if (group == null) {
                    group = new DefaultMemberGroup();
                    memberGroups.put(groupConfigEntry.getKey(), group);
                }
                group.addMember(member);
                continue block0;
            }
        }
        return new HashSet<MemberGroup>(memberGroups.values());
    }
}

