/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;

public class ChunkingOutputStream
extends BufferedOutputStream
implements HttpMessage.HeaderWriter {
    static final byte[] __CRLF = new byte[]{13, 10};
    static final byte[] __CHUNK_EOF = new byte[]{48, 13, 10};
    static final int __CHUNK_RESERVE = 8;
    static final int __EOF_RESERVE = 8;
    private HttpFields _trailer;
    private boolean _complete;
    private boolean _completed;

    public ChunkingOutputStream(OutputStream outputStream, int bufferSize, int headerReserve) {
        super(outputStream, bufferSize, headerReserve, 8, 8);
        this.setBypassBuffer(true);
        this.setFixed(true);
    }

    public void setTrailer(HttpFields trailer) {
        this._trailer = trailer;
    }

    public void flush() throws IOException {
        super.flush();
        if (this._trailer != null && this._completed) {
            this._trailer.write(this._httpMessageWriter);
            this._httpMessageWriter.writeTo(this._out);
            this._httpMessageWriter.resetWriter();
        }
    }

    public void close() throws IOException {
        this._complete = true;
        this.flush();
    }

    public void resetStream() {
        this._complete = false;
        this._completed = false;
        super.resetStream();
    }

    protected void wrapBuffer() throws IOException {
        int size = this.size();
        if (this.size() > 0) {
            this.prewrite(__CRLF, 0, __CRLF.length);
            while (size > 0) {
                int d = size % 16;
                if (d <= 9) {
                    this.prewrite(48 + d);
                } else {
                    this.prewrite(87 + d);
                }
                size /= 16;
            }
            this.postwrite(__CRLF, 0, __CRLF.length);
        }
        if (this._complete & !this._completed) {
            this._completed = true;
            this.postwrite(__CHUNK_EOF, 0, __CHUNK_EOF.length);
            if (this._trailer == null) {
                this.postwrite(__CRLF, 0, __CRLF.length);
            }
        }
    }

    protected void bypassWrite(byte[] b, int offset, int length) throws IOException {
        int i = 9;
        int chunk = length;
        this._buf[10] = 10;
        this._buf[9] = 13;
        while (chunk > 0) {
            int d = chunk % 16;
            this._buf[--i] = d <= 9 ? (byte)(48 + d) : (byte)(87 + d);
            chunk /= 16;
        }
        this._out.write(this._buf, i, 10 - i + 1);
        this._out.write(b, offset, length);
        this._out.write(__CRLF, 0, __CRLF.length);
        this._out.flush();
    }
}

